/*
 * Decompiled with CFR 0.152.
 */
package samples.graph.jai;

import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.LayeredIcon;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.DefaultVertexIconTransformer;
import edu.uci.ics.jung.visualization.decorators.EllipseVertexShapeTransformer;
import edu.uci.ics.jung.visualization.decorators.PickableEdgePaintTransformer;
import edu.uci.ics.jung.visualization.decorators.PickableVertexPaintTransformer;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.decorators.VertexIconShapeTransformer;
import edu.uci.ics.jung.visualization.jai.HyperbolicImageLensSupport;
import edu.uci.ics.jung.visualization.picking.PickedState;
import edu.uci.ics.jung.visualization.renderers.Checkmark;
import edu.uci.ics.jung.visualization.renderers.DefaultEdgeLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.DefaultVertexLabelRenderer;
import edu.uci.ics.jung.visualization.transform.LayoutLensSupport;
import edu.uci.ics.jung.visualization.transform.LensSupport;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.apache.commons.collections15.Transformer;

public class HyperbolicVertexImageShaperDemo
extends JApplet {
    private static final long serialVersionUID = 5432239991020505763L;
    DirectedSparseMultigraph<Number, Number> graph;
    VisualizationViewer<Number, Number> vv;
    String[] iconNames = new String[]{"apple", "os", "x", "linux", "inputdevices", "wireless", "graphics3", "gamespcgames", "humor", "music", "privacy"};
    LensSupport viewSupport;
    LensSupport modelSupport;

    public HyperbolicVertexImageShaperDemo() {
        this.graph = new DirectedSparseMultigraph();
        Number[] vertices = this.createVertices(11);
        HashMap<Number, String> map = new HashMap<Number, String>();
        for (int i = 0; i < vertices.length; ++i) {
            map.put(vertices[i], this.iconNames[i % this.iconNames.length]);
        }
        HashMap<Number, LayeredIcon> iconMap = new HashMap<Number, LayeredIcon>();
        for (int i = 0; i < vertices.length; ++i) {
            String name = "/images/topic" + this.iconNames[i] + ".gif";
            try {
                LayeredIcon icon = new LayeredIcon(new ImageIcon(HyperbolicVertexImageShaperDemo.class.getResource(name)).getImage());
                iconMap.put(vertices[i], icon);
                continue;
            }
            catch (Exception ex) {
                System.err.println("You need slashdoticons.jar in your classpath to see the image " + name);
            }
        }
        this.createEdges(vertices);
        FRLayout<Number, Number> layout = new FRLayout<Number, Number>(this.graph);
        layout.setMaxIterations(100);
        this.vv = new VisualizationViewer<Number, Number>(layout, new Dimension(400, 400));
        PickableVertexPaintTransformer vpf = new PickableVertexPaintTransformer(this.vv.getPickedVertexState(), Color.white, Color.yellow);
        this.vv.getRenderContext().setVertexFillPaintTransformer(vpf);
        this.vv.getRenderContext().setEdgeDrawPaintTransformer(new PickableEdgePaintTransformer(this.vv.getPickedEdgeState(), Color.black, Color.cyan));
        this.vv.setBackground(Color.white);
        VertexStringerImpl vertexStringerImpl = new VertexStringerImpl(map);
        this.vv.getRenderContext().setVertexLabelTransformer(vertexStringerImpl);
        this.vv.getRenderContext().setVertexLabelRenderer(new DefaultVertexLabelRenderer(Color.cyan));
        this.vv.getRenderContext().setEdgeLabelRenderer(new DefaultEdgeLabelRenderer(Color.cyan));
        VertexIconShapeTransformer<Number> vertexImageShapeFunction = new VertexIconShapeTransformer<Number>(new EllipseVertexShapeTransformer());
        DefaultVertexIconTransformer<Number> vertexIconFunction = new DefaultVertexIconTransformer<Number>();
        vertexImageShapeFunction.setIconMap(iconMap);
        vertexIconFunction.setIconMap(iconMap);
        this.vv.getRenderContext().setVertexShapeTransformer(vertexImageShapeFunction);
        this.vv.getRenderContext().setVertexIconTransformer(vertexIconFunction);
        PickedState ps = this.vv.getPickedVertexState();
        ps.addItemListener(new PickWithIconListener(vertexIconFunction));
        this.vv.addPostRenderPaintable(new VisualizationServer.Paintable(){
            int x;
            int y;
            Font font;
            FontMetrics metrics;
            int swidth;
            int sheight;
            String str = "Thank You, slashdot.org, for the images!";

            public void paint(Graphics g) {
                Dimension d = HyperbolicVertexImageShaperDemo.this.vv.getSize();
                if (this.font == null) {
                    this.font = new Font(g.getFont().getName(), 1, 20);
                    this.metrics = g.getFontMetrics(this.font);
                    this.swidth = this.metrics.stringWidth(this.str);
                    this.sheight = this.metrics.getMaxAscent() + this.metrics.getMaxDescent();
                    this.x = (d.width - this.swidth) / 2;
                    this.y = (int)((double)d.height - (double)this.sheight * 1.5);
                }
                g.setFont(this.font);
                Color oldColor = g.getColor();
                g.setColor(Color.lightGray);
                g.drawString(this.str, this.x, this.y);
                g.setColor(oldColor);
            }

            public boolean useTransform() {
                return false;
            }
        });
        this.vv.setVertexToolTipTransformer(new ToStringLabeller());
        Container content = this.getContentPane();
        GraphZoomScrollPane panel = new GraphZoomScrollPane(this.vv);
        content.add(panel);
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse(graphMouse);
        final CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scaler.scale(HyperbolicVertexImageShaperDemo.this.vv, 1.1f, HyperbolicVertexImageShaperDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scaler.scale(HyperbolicVertexImageShaperDemo.this.vv, 0.9090909f, HyperbolicVertexImageShaperDemo.this.vv.getCenter());
            }
        });
        JComboBox modeBox = graphMouse.getModeComboBox();
        JPanel modePanel = new JPanel();
        modePanel.setBorder(BorderFactory.createTitledBorder("Mouse Mode"));
        modePanel.add(modeBox);
        JPanel scaleGrid = new JPanel(new GridLayout(1, 0));
        scaleGrid.setBorder(BorderFactory.createTitledBorder("Zoom"));
        JPanel controls = new JPanel();
        scaleGrid.add(plus);
        scaleGrid.add(minus);
        controls.add(scaleGrid);
        controls.add(modePanel);
        content.add((Component)controls, "South");
        this.viewSupport = new HyperbolicImageLensSupport<Number, Number>(this.vv);
        this.modelSupport = new LayoutLensSupport<Number, Number>(this.vv);
        graphMouse.addItemListener(this.modelSupport.getGraphMouse().getModeListener());
        graphMouse.addItemListener(this.viewSupport.getGraphMouse().getModeListener());
        ButtonGroup radio = new ButtonGroup();
        JRadioButton none = new JRadioButton("None");
        none.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (HyperbolicVertexImageShaperDemo.this.viewSupport != null) {
                    HyperbolicVertexImageShaperDemo.this.viewSupport.deactivate();
                }
                if (HyperbolicVertexImageShaperDemo.this.modelSupport != null) {
                    HyperbolicVertexImageShaperDemo.this.modelSupport.deactivate();
                }
            }
        });
        none.setSelected(true);
        JRadioButton hyperView = new JRadioButton("View");
        hyperView.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                HyperbolicVertexImageShaperDemo.this.viewSupport.activate(e.getStateChange() == 1);
            }
        });
        JRadioButton hyperModel = new JRadioButton("Layout");
        hyperModel.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                HyperbolicVertexImageShaperDemo.this.modelSupport.activate(e.getStateChange() == 1);
            }
        });
        radio.add(none);
        radio.add(hyperView);
        radio.add(hyperModel);
        JMenuBar menubar = new JMenuBar();
        JMenu modeMenu = graphMouse.getModeMenu();
        menubar.add(modeMenu);
        JPanel lensPanel = new JPanel(new GridLayout(2, 0));
        lensPanel.setBorder(BorderFactory.createTitledBorder("Lens"));
        lensPanel.add(none);
        lensPanel.add(hyperView);
        lensPanel.add(hyperModel);
        controls.add(lensPanel);
    }

    private Number[] createVertices(int count) {
        Number[] v = new Number[count];
        for (int i = 0; i < count; ++i) {
            v[i] = new Integer(i);
            this.graph.addVertex(v[i]);
        }
        return v;
    }

    void createEdges(Number[] v) {
        this.graph.addEdge(new Double(Math.random()), v[0], v[1], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[3], v[0], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[0], v[4], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[4], v[5], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[5], v[3], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[2], v[1], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[4], v[1], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[8], v[2], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[3], v[8], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[6], v[7], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[7], v[5], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[0], v[9], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[9], v[8], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[7], v[6], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[6], v[5], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[4], v[2], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[5], v[4], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[4], v[10], EdgeType.DIRECTED);
        this.graph.addEdge(new Double(Math.random()), v[10], v[4], EdgeType.DIRECTED);
    }

    public static void main(String[] args) {
        JFrame frame = new JFrame();
        Container content = frame.getContentPane();
        frame.setDefaultCloseOperation(3);
        content.add(new HyperbolicVertexImageShaperDemo());
        frame.pack();
        frame.setVisible(true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PickWithIconListener
    implements ItemListener {
        DefaultVertexIconTransformer<Number> imager;
        Icon checked;

        public PickWithIconListener(DefaultVertexIconTransformer<Number> imager) {
            this.imager = imager;
            this.checked = new Checkmark(Color.red);
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            Object icon = this.imager.transform((Object)((Number)e.getItem()));
            if (icon != null && icon instanceof LayeredIcon) {
                if (e.getStateChange() == 1) {
                    ((LayeredIcon)icon).add(this.checked);
                } else {
                    ((LayeredIcon)icon).remove(this.checked);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class VertexStringerImpl<V>
    implements Transformer<V, String> {
        Map<V, String> map = new HashMap<V, String>();
        boolean enabled = true;

        public VertexStringerImpl(Map<V, String> map) {
            this.map = map;
        }

        @Override
        public String transform(V v) {
            if (this.isEnabled()) {
                return this.map.get(v);
            }
            return "";
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }
    }
}

