/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung3d.algorithms.layout;

import edu.uci.ics.jung3d.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung3d.algorithms.layout.Layout;
import java.util.ConcurrentModificationException;
import javax.vecmath.Point3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RadiusGraphElementAccessor<V, E>
implements GraphElementAccessor<V, E> {
    protected double maxDistance;

    public RadiusGraphElementAccessor() {
        this(Math.sqrt(Double.MAX_VALUE));
    }

    public RadiusGraphElementAccessor(double maxDistance) {
        this.maxDistance = maxDistance;
    }

    @Override
    public V getVertex(Layout<V, E> layout, Point3f p) {
        return this.getVertex(layout, p, this.maxDistance);
    }

    public V getVertex(Layout<V, E> layout, Point3f p, double maxDistance) {
        double minDistance = maxDistance * maxDistance;
        V closest = null;
        while (true) {
            try {
                for (Object v : layout.getGraph().getVertices()) {
                    Point3f p2 = (Point3f)layout.transform(v);
                    double dist = p.distance(p2);
                    if (!(dist < minDistance)) continue;
                    minDistance = dist;
                    closest = v;
                }
            }
            catch (ConcurrentModificationException cme) {
                continue;
            }
            break;
        }
        return closest;
    }
}

