/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.renderers;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.visualization.RenderContext;
import java.awt.Dimension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Renderer<V, E> {
    public void render(RenderContext<V, E> var1, Layout<V, E> var2);

    public void renderVertex(RenderContext<V, E> var1, Layout<V, E> var2, V var3);

    public void renderVertexLabel(RenderContext<V, E> var1, Layout<V, E> var2, V var3);

    public void renderEdge(RenderContext<V, E> var1, Layout<V, E> var2, E var3);

    public void renderEdgeLabel(RenderContext<V, E> var1, Layout<V, E> var2, E var3);

    public void setVertexRenderer(Vertex<V, E> var1);

    public void setEdgeRenderer(Edge<V, E> var1);

    public void setVertexLabelRenderer(VertexLabel<V, E> var1);

    public void setEdgeLabelRenderer(EdgeLabel<V, E> var1);

    public VertexLabel<V, E> getVertexLabelRenderer();

    public Vertex<V, E> getVertexRenderer();

    public Edge<V, E> getEdgeRenderer();

    public EdgeLabel<V, E> getEdgeLabelRenderer();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface EdgeLabel<V, E> {
        public void labelEdge(RenderContext<V, E> var1, Layout<V, E> var2, E var3, String var4);

        public static class NOOP
        implements EdgeLabel {
            public void labelEdge(RenderContext rc, Layout layout, Object e, String label) {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface VertexLabel<V, E> {
        public void labelVertex(RenderContext<V, E> var1, Layout<V, E> var2, V var3, String var4);

        public Position getPosition();

        public void setPosition(Position var1);

        public void setPositioner(Positioner var1);

        public Positioner getPositioner();

        public static interface Positioner {
            public Position getPosition(float var1, float var2, Dimension var3);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Position {
            N,
            NE,
            E,
            SE,
            S,
            SW,
            W,
            NW,
            CNTR,
            AUTO;

        }

        public static class NOOP
        implements VertexLabel {
            public void labelVertex(RenderContext rc, Layout layout, Object v, String label) {
            }

            public Position getPosition() {
                return Position.CNTR;
            }

            public void setPosition(Position position) {
            }

            public Positioner getPositioner() {
                return new Positioner(){

                    public Position getPosition(float x, float y, Dimension d) {
                        return Position.CNTR;
                    }
                };
            }

            public void setPositioner(Positioner positioner) {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Edge<V, E> {
        public void paintEdge(RenderContext<V, E> var1, Layout<V, E> var2, E var3);

        public static class NOOP
        implements Edge {
            public void paintEdge(RenderContext rc, Layout layout, Object e) {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Vertex<V, E> {
        public void paintVertex(RenderContext<V, E> var1, Layout<V, E> var2, V var3);

        public static class NOOP
        implements Vertex {
            public void paintVertex(RenderContext rc, Layout layout, Object v) {
            }
        }
    }
}

