/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.renderers;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Context;
import edu.uci.ics.jung.graph.util.EdgeIndexFunction;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.transform.LensTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicEdgeRenderer<V, E>
implements Renderer.Edge<V, E> {
    @Override
    public void paintEdge(RenderContext<V, E> rc, Layout<V, E> layout, E e) {
        GraphicsDecorator g2d = rc.getGraphicsContext();
        Graph<V, E> graph = layout.getGraph();
        if (!rc.getEdgeIncludePredicate().evaluate(Context.getInstance(graph, e))) {
            return;
        }
        Pair<V> endpoints = graph.getEndpoints(e);
        V v1 = endpoints.getFirst();
        V v2 = endpoints.getSecond();
        if (!rc.getVertexIncludePredicate().evaluate(Context.getInstance(graph, v1)) || !rc.getVertexIncludePredicate().evaluate(Context.getInstance(graph, v2))) {
            return;
        }
        Stroke new_stroke = rc.getEdgeStrokeTransformer().transform(e);
        Stroke old_stroke = g2d.getStroke();
        if (new_stroke != null) {
            g2d.setStroke(new_stroke);
        }
        this.drawSimpleEdge(rc, layout, e);
        if (new_stroke != null) {
            g2d.setStroke(old_stroke);
        }
    }

    protected void drawSimpleEdge(RenderContext<V, E> rc, Layout<V, E> layout, E e) {
        float dy;
        GraphicsDecorator g = rc.getGraphicsContext();
        Graph<V, E> graph = layout.getGraph();
        Pair<V> endpoints = graph.getEndpoints(e);
        V v1 = endpoints.getFirst();
        V v2 = endpoints.getSecond();
        Point2D p1 = (Point2D)layout.transform(v1);
        Point2D p2 = (Point2D)layout.transform(v2);
        p1 = rc.getMultiLayerTransformer().transform(Layer.LAYOUT, p1);
        p2 = rc.getMultiLayerTransformer().transform(Layer.LAYOUT, p2);
        float x1 = (float)p1.getX();
        float y1 = (float)p1.getY();
        float x2 = (float)p2.getX();
        float y2 = (float)p2.getY();
        boolean isLoop = v1.equals(v2);
        Shape s2 = rc.getVertexShapeTransformer().transform(v2);
        Shape edgeShape = rc.getEdgeShapeTransformer().transform(Context.getInstance(graph, e));
        boolean edgeHit = true;
        boolean arrowHit = true;
        Rectangle deviceRectangle = null;
        JComponent vv = rc.getScreenDevice();
        if (vv != null) {
            Dimension d = vv.getSize();
            deviceRectangle = new Rectangle(0, 0, d.width, d.height);
        }
        AffineTransform xform = AffineTransform.getTranslateInstance(x1, y1);
        if (isLoop) {
            Rectangle2D s2Bounds = s2.getBounds2D();
            xform.scale(s2Bounds.getWidth(), s2Bounds.getHeight());
            xform.translate(0.0, -edgeShape.getBounds2D().getWidth() / 2.0);
        } else if (rc.getEdgeShapeTransformer() instanceof EdgeShape.Orthogonal) {
            float dx = x2 - x1;
            dy = y2 - y1;
            int index = 0;
            if (rc.getEdgeShapeTransformer() instanceof EdgeShape.IndexedRendering) {
                EdgeIndexFunction<V, E> peif = ((EdgeShape.IndexedRendering)((Object)rc.getEdgeShapeTransformer())).getEdgeIndexFunction();
                index = peif.getIndex(graph, e);
                index *= 20;
            }
            GeneralPath gp = new GeneralPath();
            gp.moveTo(0.0f, 0.0f);
            if (x1 > x2) {
                if (y1 > y2) {
                    gp.lineTo(0.0f, index);
                    gp.lineTo(dx - (float)index, index);
                    gp.lineTo(dx - (float)index, dy);
                    gp.lineTo(dx, dy);
                } else {
                    gp.lineTo(0.0f, -index);
                    gp.lineTo(dx - (float)index, -index);
                    gp.lineTo(dx - (float)index, dy);
                    gp.lineTo(dx, dy);
                }
            } else if (y1 > y2) {
                gp.lineTo(0.0f, index);
                gp.lineTo(dx + (float)index, index);
                gp.lineTo(dx + (float)index, dy);
                gp.lineTo(dx, dy);
            } else {
                gp.lineTo(0.0f, -index);
                gp.lineTo(dx + (float)index, -index);
                gp.lineTo(dx + (float)index, dy);
                gp.lineTo(dx, dy);
            }
            edgeShape = gp;
        } else {
            float dx = x2 - x1;
            dy = y2 - y1;
            float thetaRadians = (float)Math.atan2(dy, dx);
            xform.rotate(thetaRadians);
            float dist = (float)Math.sqrt(dx * dx + dy * dy);
            xform.scale(dist, 1.0);
        }
        edgeShape = xform.createTransformedShape(edgeShape);
        MutableTransformer vt = rc.getMultiLayerTransformer().getTransformer(Layer.VIEW);
        if (vt instanceof LensTransformer) {
            vt = ((LensTransformer)vt).getDelegate();
        }
        if (edgeHit = vt.transform(edgeShape).intersects(deviceRectangle)) {
            Paint draw_paint;
            Paint oldPaint = g.getPaint();
            Paint fill_paint = rc.getEdgeFillPaintTransformer().transform(e);
            if (fill_paint != null) {
                g.setPaint(fill_paint);
                g.fill(edgeShape);
            }
            if ((draw_paint = rc.getEdgeDrawPaintTransformer().transform(e)) != null) {
                g.setPaint(draw_paint);
                g.draw(edgeShape);
            }
            float scalex = (float)g.getTransform().getScaleX();
            float scaley = (float)g.getTransform().getScaleY();
            if ((double)scalex < 0.3 || (double)scaley < 0.3) {
                return;
            }
            if (rc.getEdgeArrowPredicate().evaluate(Context.getInstance(graph, e))) {
                Stroke new_stroke = rc.getEdgeArrowStrokeTransformer().transform(e);
                Stroke old_stroke = g.getStroke();
                if (new_stroke != null) {
                    g.setStroke(new_stroke);
                }
                Shape destVertexShape = rc.getVertexShapeTransformer().transform(graph.getEndpoints(e).getSecond());
                AffineTransform xf = AffineTransform.getTranslateInstance(x2, y2);
                destVertexShape = xf.createTransformedShape(destVertexShape);
                arrowHit = rc.getMultiLayerTransformer().getTransformer(Layer.VIEW).transform(destVertexShape).intersects(deviceRectangle);
                if (arrowHit) {
                    AffineTransform at = this.getArrowTransform(rc, new GeneralPath(edgeShape), destVertexShape);
                    if (at == null) {
                        return;
                    }
                    Shape arrow = rc.getEdgeArrowTransformer().transform(Context.getInstance(graph, e));
                    arrow = at.createTransformedShape(arrow);
                    g.setPaint(rc.getArrowFillPaintTransformer().transform(e));
                    g.fill(arrow);
                    g.setPaint(rc.getArrowDrawPaintTransformer().transform(e));
                    g.draw(arrow);
                }
                if (graph.getEdgeType(e) == EdgeType.UNDIRECTED) {
                    Shape vertexShape = rc.getVertexShapeTransformer().transform(graph.getEndpoints(e).getFirst());
                    xf = AffineTransform.getTranslateInstance(x1, y1);
                    vertexShape = xf.createTransformedShape(vertexShape);
                    arrowHit = rc.getMultiLayerTransformer().getTransformer(Layer.VIEW).transform(vertexShape).intersects(deviceRectangle);
                    if (arrowHit) {
                        AffineTransform at = this.getReverseArrowTransform(rc, new GeneralPath(edgeShape), vertexShape, !isLoop);
                        if (at == null) {
                            return;
                        }
                        Shape arrow = rc.getEdgeArrowTransformer().transform(Context.getInstance(graph, e));
                        arrow = at.createTransformedShape(arrow);
                        g.setPaint(rc.getArrowFillPaintTransformer().transform(e));
                        g.fill(arrow);
                        g.setPaint(rc.getArrowDrawPaintTransformer().transform(e));
                        g.draw(arrow);
                    }
                }
                if (new_stroke != null) {
                    g.setStroke(old_stroke);
                }
            }
            g.setPaint(oldPaint);
        }
    }

    public AffineTransform getArrowTransform(RenderContext<V, E> rc, GeneralPath edgeShape, Shape vertexShape) {
        float[] seg = new float[6];
        Point2D.Float p1 = null;
        Point2D.Float p2 = null;
        AffineTransform at = new AffineTransform();
        PathIterator i = edgeShape.getPathIterator(null, 1.0);
        while (!i.isDone()) {
            int ret = i.currentSegment(seg);
            if (ret == 0) {
                p2 = new Point2D.Float(seg[0], seg[1]);
            } else if (ret == 1) {
                p1 = p2;
                p2 = new Point2D.Float(seg[0], seg[1]);
                if (vertexShape.contains(p2)) {
                    at = this.getArrowTransform(rc, new Line2D.Float(p1, p2), vertexShape);
                    break;
                }
            }
            i.next();
        }
        return at;
    }

    public AffineTransform getReverseArrowTransform(RenderContext<V, E> rc, GeneralPath edgeShape, Shape vertexShape) {
        return this.getReverseArrowTransform(rc, edgeShape, vertexShape, true);
    }

    public AffineTransform getReverseArrowTransform(RenderContext<V, E> rc, GeneralPath edgeShape, Shape vertexShape, boolean passedGo) {
        float[] seg = new float[6];
        Point2D.Float p1 = null;
        Point2D.Float p2 = null;
        AffineTransform at = new AffineTransform();
        PathIterator i = edgeShape.getPathIterator(null, 1.0);
        while (!i.isDone()) {
            int ret = i.currentSegment(seg);
            if (ret == 0) {
                p2 = new Point2D.Float(seg[0], seg[1]);
            } else if (ret == 1) {
                p1 = p2;
                p2 = new Point2D.Float(seg[0], seg[1]);
                if (!passedGo && vertexShape.contains(p2)) {
                    passedGo = true;
                } else if (passedGo && !vertexShape.contains(p2)) {
                    at = this.getReverseArrowTransform(rc, new Line2D.Float(p1, p2), vertexShape);
                    break;
                }
            }
            i.next();
        }
        return at;
    }

    public AffineTransform getArrowTransform(RenderContext<V, E> rc, Line2D edgeShape, Shape vertexShape) {
        float dx = (float)(edgeShape.getX1() - edgeShape.getX2());
        float dy = (float)(edgeShape.getY1() - edgeShape.getY2());
        while (dx * dx + dy * dy > rc.getArrowPlacementTolerance()) {
            try {
                edgeShape = this.getLastOutsideSegment(edgeShape, vertexShape);
            }
            catch (IllegalArgumentException e) {
                System.err.println(e.toString());
                return null;
            }
            dx = (float)(edgeShape.getX1() - edgeShape.getX2());
            dy = (float)(edgeShape.getY1() - edgeShape.getY2());
        }
        double atheta = Math.atan2(dx, dy) + 1.5707963267948966;
        AffineTransform at = AffineTransform.getTranslateInstance(edgeShape.getX1(), edgeShape.getY1());
        at.rotate(-atheta);
        return at;
    }

    protected AffineTransform getReverseArrowTransform(RenderContext<V, E> rc, Line2D edgeShape, Shape vertexShape) {
        float dx = (float)(edgeShape.getX1() - edgeShape.getX2());
        float dy = (float)(edgeShape.getY1() - edgeShape.getY2());
        while (dx * dx + dy * dy > rc.getArrowPlacementTolerance()) {
            try {
                edgeShape = this.getFirstOutsideSegment(edgeShape, vertexShape);
            }
            catch (IllegalArgumentException e) {
                System.err.println(e.toString());
                return null;
            }
            dx = (float)(edgeShape.getX1() - edgeShape.getX2());
            dy = (float)(edgeShape.getY1() - edgeShape.getY2());
        }
        double atheta = Math.atan2(dx, dy) - 1.5707963267948966;
        AffineTransform at = AffineTransform.getTranslateInstance(edgeShape.getX1(), edgeShape.getY1());
        at.rotate(-atheta);
        return at;
    }

    protected Line2D getLastOutsideSegment(Line2D line, Shape shape) {
        if (!shape.contains(line.getP2())) {
            String errorString = "line end point: " + line.getP2() + " is not contained in shape: " + shape.getBounds2D();
            throw new IllegalArgumentException(errorString);
        }
        Line2D.Double left = new Line2D.Double();
        Line2D.Double right = new Line2D.Double();
        do {
            this.subdivide(line, left, right);
        } while (!shape.contains((line = right).getP1()));
        return left;
    }

    protected Line2D getFirstOutsideSegment(Line2D line, Shape shape) {
        if (!shape.contains(line.getP1())) {
            String errorString = "line start point: " + line.getP1() + " is not contained in shape: " + shape.getBounds2D();
            throw new IllegalArgumentException(errorString);
        }
        Line2D.Float left = new Line2D.Float();
        Line2D.Float right = new Line2D.Float();
        do {
            this.subdivide(line, left, right);
        } while (!shape.contains((line = left).getP2()));
        return right;
    }

    protected void subdivide(Line2D src, Line2D left, Line2D right) {
        double x1 = src.getX1();
        double y1 = src.getY1();
        double x2 = src.getX2();
        double y2 = src.getY2();
        double mx = x1 + (x2 - x1) / 2.0;
        double my = y1 + (y2 - y1) / 2.0;
        if (left != null) {
            left.setLine(x1, y1, mx, my);
        }
        if (right != null) {
            right.setLine(mx, my, x2, y2);
        }
    }
}

