/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.layout;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.LayoutDecorator;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.visualization.util.Caching;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.functors.ChainedTransformer;
import org.apache.commons.collections15.functors.CloneTransformer;
import org.apache.commons.collections15.map.LazyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachingLayout<V, E>
extends LayoutDecorator<V, E>
implements Caching {
    protected Map<V, Point2D> locationMap;

    public CachingLayout(Layout<V, E> delegate) {
        super(delegate);
        this.locationMap = LazyMap.decorate(new HashMap(), new ChainedTransformer(new Transformer[]{delegate, CloneTransformer.getInstance()}));
    }

    @Override
    public void setGraph(Graph<V, E> graph) {
        this.delegate.setGraph(graph);
    }

    @Override
    public void clear() {
        this.locationMap.clear();
    }

    @Override
    public void init() {
    }

    @Override
    public Point2D transform(V v) {
        return this.locationMap.get(v);
    }
}

