/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.decorators;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;

public class Arrow {
    public static final String CLASSIC = "Arrow.CLASSIC";
    public static final String SLEEK = "Arrow.SLEEK";
    protected String m_arrowType;
    protected int m_arrowLength = 4;
    protected int m_arrowWidth = 10;
    protected Stroke m_arrowStroke;
    GeneralPath arrowhead;

    public Arrow(String type, int length, int width) {
        this.m_arrowType = type;
        if (length > 0) {
            this.m_arrowLength = length;
        }
        if (width > 0) {
            this.m_arrowWidth = width;
        }
        this.m_arrowStroke = new BasicStroke(2.0f);
        this.arrowhead = this.m_arrowType == SLEEK ? this.getSleekArrow() : this.getClassicArrow();
    }

    public void drawArrow(Graphics2D g2d, int sourceX, int sourceY, int destX, int destY, int vertexDiam) {
        Stroke oldStroke = g2d.getStroke();
        g2d.setStroke(this.m_arrowStroke);
        Point point1 = new Point(sourceX, sourceY);
        Point point2 = new Point(destX, destY);
        double thetaRadians = Math.atan2(point1.getY() - point2.getY(), point1.getX() - point2.getX()) + Math.PI;
        AffineTransform at = new AffineTransform();
        at.translate(point2.getX(), point2.getY());
        at.rotate(thetaRadians);
        at.translate((float)(-vertexDiam) / 2.0f, 0.0);
        Shape arrow = at.createTransformedShape(this.arrowhead);
        g2d.fill(arrow);
        g2d.setStroke(oldStroke);
    }

    protected GeneralPath getSleekArrow() {
        GeneralPath arrow = new GeneralPath();
        int width = (int)((float)this.m_arrowWidth / 2.0f);
        arrow.moveTo(0.0f, 0.0f);
        arrow.lineTo(-this.m_arrowLength, width);
        arrow.lineTo(-this.m_arrowLength, -width);
        arrow.lineTo(0.0f, 0.0f);
        return arrow;
    }

    protected GeneralPath getClassicArrow() {
        GeneralPath arrow = new GeneralPath();
        float distance = 0.0f;
        int width = (int)((float)this.m_arrowWidth / 2.0f);
        arrow.moveTo(distance, 0.0f);
        arrow.lineTo(distance - (float)this.m_arrowLength, width);
        arrow.lineTo(distance - (float)this.m_arrowLength, -width);
        arrow.lineTo(distance, 0.0f);
        return arrow;
    }
}

