/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.TestGraphs;
import edu.uci.ics.jung.visualization.DefaultVisualizationModel;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.AnimatedPickingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.LayoutScalingControl;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.control.PickingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.RotatingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.ScalingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.ShearingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.TranslatingGraphMousePlugin;
import edu.uci.ics.jung.visualization.control.ViewScalingControl;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import edu.uci.ics.jung.visualization.decorators.PickableEdgePaintTransformer;
import edu.uci.ics.jung.visualization.decorators.PickableVertexPaintTransformer;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.picking.MultiPickedState;
import edu.uci.ics.jung.visualization.picking.ShapePickSupport;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Rectangle2D;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.apache.commons.collections15.functors.ConstantTransformer;

public class MultiViewDemo
extends JApplet {
    Graph<String, Number> graph;
    VisualizationViewer<String, Number> vv1;
    VisualizationViewer<String, Number> vv2;
    VisualizationViewer<String, Number> vv3;
    Dimension preferredSize = new Dimension(300, 300);
    final String messageOne = "The mouse wheel will scale the model's layout when activated in View 1. Since all three views share the same layout transformer, all three views will show the same scaling of the layout.";
    final String messageTwo = "The mouse wheel will scale the view when activated in View 2. Since all three views share the same view transformer, all three views will be affected.";
    final String messageThree = "   The mouse wheel uses a 'crossover' feature in View 3. When the combined layout and view scale is greater than '1', the model's layout will be scaled. Since all three views share the same layout transformer, all three views will show the same  scaling of the layout.\n   When the combined scale is less than '1', the scaling function crosses over to the view, and then, since all three views share the same view transformer, all three views will show the same scaling.";
    JTextArea textArea;
    JScrollPane scrollPane;

    public MultiViewDemo() {
        this.graph = TestGraphs.getOneComponentGraph();
        FRLayout<String, Number> layout = new FRLayout<String, Number>(this.graph);
        layout.setMaxIterations(1000);
        DefaultVisualizationModel<String, Number> visualizationModel = new DefaultVisualizationModel<String, Number>(layout, this.preferredSize);
        this.vv1 = new VisualizationViewer<String, Number>(visualizationModel, this.preferredSize);
        this.vv2 = new VisualizationViewer<String, Number>(visualizationModel, this.preferredSize);
        this.vv3 = new VisualizationViewer<String, Number>(visualizationModel, this.preferredSize);
        this.vv1.getRenderContext().setEdgeShapeTransformer(new EdgeShape.Line());
        this.vv2.getRenderContext().setVertexShapeTransformer(new ConstantTransformer<Shape>(new Rectangle2D.Float(-6.0f, -6.0f, 12.0f, 12.0f)));
        this.vv2.getRenderContext().setEdgeShapeTransformer(new EdgeShape.QuadCurve());
        this.vv3.getRenderContext().setEdgeShapeTransformer(new EdgeShape.CubicCurve());
        this.vv2.getRenderContext().setMultiLayerTransformer(this.vv1.getRenderContext().getMultiLayerTransformer());
        this.vv3.getRenderContext().setMultiLayerTransformer(this.vv1.getRenderContext().getMultiLayerTransformer());
        this.vv1.getRenderContext().getMultiLayerTransformer().addChangeListener(this.vv1);
        this.vv2.getRenderContext().getMultiLayerTransformer().addChangeListener(this.vv2);
        this.vv3.getRenderContext().getMultiLayerTransformer().addChangeListener(this.vv3);
        this.vv1.setBackground(Color.white);
        this.vv2.setBackground(Color.white);
        this.vv3.setBackground(Color.white);
        ShapePickSupport<String, Number> pickSupport = new ShapePickSupport<String, Number>(this.vv1);
        this.vv1.setPickSupport(pickSupport);
        this.vv2.setPickSupport(pickSupport);
        this.vv3.setPickSupport(pickSupport);
        MultiPickedState pes = new MultiPickedState();
        MultiPickedState pvs = new MultiPickedState();
        this.vv1.setPickedVertexState(pvs);
        this.vv2.setPickedVertexState(pvs);
        this.vv3.setPickedVertexState(pvs);
        this.vv1.setPickedEdgeState(pes);
        this.vv2.setPickedEdgeState(pes);
        this.vv3.setPickedEdgeState(pes);
        this.vv1.getRenderContext().setEdgeDrawPaintTransformer(new PickableEdgePaintTransformer(pes, Color.black, Color.red));
        this.vv2.getRenderContext().setEdgeDrawPaintTransformer(new PickableEdgePaintTransformer(pes, Color.black, Color.red));
        this.vv3.getRenderContext().setEdgeDrawPaintTransformer(new PickableEdgePaintTransformer(pes, Color.black, Color.red));
        this.vv1.getRenderContext().setVertexFillPaintTransformer(new PickableVertexPaintTransformer(pvs, Color.red, Color.yellow));
        this.vv2.getRenderContext().setVertexFillPaintTransformer(new PickableVertexPaintTransformer(pvs, Color.blue, Color.cyan));
        this.vv3.getRenderContext().setVertexFillPaintTransformer(new PickableVertexPaintTransformer(pvs, Color.red, Color.yellow));
        this.vv1.setVertexToolTipTransformer(new ToStringLabeller());
        this.vv2.setVertexToolTipTransformer(new ToStringLabeller());
        this.vv3.setVertexToolTipTransformer(new ToStringLabeller());
        Container content = this.getContentPane();
        JPanel panel = new JPanel(new GridLayout(1, 0));
        final JPanel p1 = new JPanel(new BorderLayout());
        final JPanel p2 = new JPanel(new BorderLayout());
        final JPanel p3 = new JPanel(new BorderLayout());
        p1.add(new GraphZoomScrollPane(this.vv1));
        p2.add(new GraphZoomScrollPane(this.vv2));
        p3.add(new GraphZoomScrollPane(this.vv3));
        JButton h1 = new JButton("?");
        h1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiViewDemo.this.textArea.setText("The mouse wheel will scale the model's layout when activated in View 1. Since all three views share the same layout transformer, all three views will show the same scaling of the layout.");
                JOptionPane.showMessageDialog(p1, MultiViewDemo.this.scrollPane, "View 1", -1);
            }
        });
        JButton h2 = new JButton("?");
        h2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiViewDemo.this.textArea.setText("The mouse wheel will scale the view when activated in View 2. Since all three views share the same view transformer, all three views will be affected.");
                JOptionPane.showMessageDialog(p2, MultiViewDemo.this.scrollPane, "View 2", -1);
            }
        });
        JButton h3 = new JButton("?");
        h3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MultiViewDemo.this.textArea.setText("   The mouse wheel uses a 'crossover' feature in View 3. When the combined layout and view scale is greater than '1', the model's layout will be scaled. Since all three views share the same layout transformer, all three views will show the same  scaling of the layout.\n   When the combined scale is less than '1', the scaling function crosses over to the view, and then, since all three views share the same view transformer, all three views will show the same scaling.");
                MultiViewDemo.this.textArea.setCaretPosition(0);
                JOptionPane.showMessageDialog(p3, MultiViewDemo.this.scrollPane, "View 3", -1);
            }
        });
        DefaultModalGraphMouse gm1 = new DefaultModalGraphMouse(){

            protected void loadPlugins() {
                this.pickingPlugin = new PickingGraphMousePlugin();
                this.animatedPickingPlugin = new AnimatedPickingGraphMousePlugin();
                this.translatingPlugin = new TranslatingGraphMousePlugin(16);
                this.scalingPlugin = new ScalingGraphMousePlugin(new LayoutScalingControl(), 0);
                this.rotatingPlugin = new RotatingGraphMousePlugin();
                this.shearingPlugin = new ShearingGraphMousePlugin();
                this.add(this.scalingPlugin);
                this.setMode(ModalGraphMouse.Mode.TRANSFORMING);
            }
        };
        DefaultModalGraphMouse gm2 = new DefaultModalGraphMouse(){

            protected void loadPlugins() {
                this.pickingPlugin = new PickingGraphMousePlugin();
                this.animatedPickingPlugin = new AnimatedPickingGraphMousePlugin();
                this.translatingPlugin = new TranslatingGraphMousePlugin(16);
                this.scalingPlugin = new ScalingGraphMousePlugin(new ViewScalingControl(), 0);
                this.rotatingPlugin = new RotatingGraphMousePlugin();
                this.shearingPlugin = new ShearingGraphMousePlugin();
                this.add(this.scalingPlugin);
                this.setMode(ModalGraphMouse.Mode.TRANSFORMING);
            }
        };
        DefaultModalGraphMouse gm3 = new DefaultModalGraphMouse(){};
        this.vv1.setGraphMouse(gm1);
        this.vv2.setGraphMouse(gm2);
        this.vv3.setGraphMouse(gm3);
        this.vv1.setToolTipText("<html><center>MouseWheel Scales Layout</center></html>");
        this.vv2.setToolTipText("<html><center>MouseWheel Scales View</center></html>");
        this.vv3.setToolTipText("<html><center>MouseWheel Scales Layout and<p>crosses over to view<p>ctrl+MouseWheel scales view</center></html>");
        this.vv1.addPostRenderPaintable(new BannerLabel(this.vv1, "View 1"));
        this.vv2.addPostRenderPaintable(new BannerLabel(this.vv2, "View 2"));
        this.vv3.addPostRenderPaintable(new BannerLabel(this.vv3, "View 3"));
        this.textArea = new JTextArea(6, 30);
        this.scrollPane = new JScrollPane(this.textArea, 20, 31);
        this.textArea.setLineWrap(true);
        this.textArea.setWrapStyleWord(true);
        this.textArea.setEditable(false);
        JPanel flow = new JPanel();
        flow.add(h1);
        flow.add(gm1.getModeComboBox());
        p1.add((Component)flow, "South");
        flow = new JPanel();
        flow.add(h2);
        flow.add(gm2.getModeComboBox());
        p2.add((Component)flow, "South");
        flow = new JPanel();
        flow.add(h3);
        flow.add(gm3.getModeComboBox());
        p3.add((Component)flow, "South");
        panel.add(p1);
        panel.add(p2);
        panel.add(p3);
        content.add(panel);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame();
        f.setDefaultCloseOperation(3);
        f.getContentPane().add(new MultiViewDemo());
        f.pack();
        f.setVisible(true);
    }

    class BannerLabel
    implements VisualizationServer.Paintable {
        int x;
        int y;
        Font font;
        FontMetrics metrics;
        int swidth;
        int sheight;
        String str;
        VisualizationViewer vv;

        public BannerLabel(VisualizationViewer vv, String label) {
            this.vv = vv;
            this.str = label;
        }

        public void paint(Graphics g) {
            Dimension d = this.vv.getSize();
            if (this.font == null) {
                this.font = new Font(g.getFont().getName(), 1, 30);
                this.metrics = g.getFontMetrics(this.font);
                this.swidth = this.metrics.stringWidth(this.str);
                this.sheight = this.metrics.getMaxAscent() + this.metrics.getMaxDescent();
                this.x = (3 * d.width / 2 - this.swidth) / 2;
                this.y = d.height - this.sheight;
            }
            g.setFont(this.font);
            Color oldColor = g.getColor();
            g.setColor(Color.gray);
            g.drawString(this.str, this.x, this.y);
            g.setColor(oldColor);
        }

        public boolean useTransform() {
            return false;
        }
    }
}

