/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.samples;

import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.io.GraphMLReader;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.GraphMouseListener;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.renderers.BasicVertexLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.GradientVertexRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.Transformer;
import org.xml.sax.SAXException;

public class GraphFromGraphMLDemo {
    VisualizationViewer<Number, Number> vv;

    public GraphFromGraphMLDemo(String filename) throws ParserConfigurationException, SAXException, IOException {
        Factory<Number> vertexFactory = new Factory<Number>(){
            int n = 0;

            @Override
            public Number create() {
                return this.n++;
            }
        };
        Factory<Number> edgeFactory = new Factory<Number>(){
            int n = 0;

            @Override
            public Number create() {
                return this.n++;
            }
        };
        GraphMLReader gmlr = new GraphMLReader(vertexFactory, edgeFactory);
        final DirectedSparseMultigraph graph = new DirectedSparseMultigraph();
        gmlr.load(filename, graph);
        this.vv = new VisualizationViewer(new FRLayout(graph));
        this.vv.addGraphMouseListener(new TestGraphMouseListener());
        this.vv.getRenderer().setVertexRenderer(new GradientVertexRenderer(Color.white, Color.red, Color.white, Color.blue, this.vv.getPickedVertexState(), false));
        this.vv.setVertexToolTipTransformer(new ToStringLabeller());
        this.vv.setEdgeToolTipTransformer(new Transformer<Number, String>(){

            @Override
            public String transform(Number edge) {
                return "E" + graph.getEndpoints(edge).toString();
            }
        });
        this.vv.getRenderContext().setVertexLabelTransformer(new ToStringLabeller());
        this.vv.getRenderer().getVertexLabelRenderer().setPositioner(new BasicVertexLabelRenderer.InsidePositioner());
        this.vv.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.AUTO);
        JFrame frame = new JFrame();
        Container content = frame.getContentPane();
        GraphZoomScrollPane panel = new GraphZoomScrollPane(this.vv);
        content.add(panel);
        frame.setDefaultCloseOperation(3);
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse(graphMouse);
        this.vv.addKeyListener(graphMouse.getModeKeyListener());
        JMenuBar menubar = new JMenuBar();
        menubar.add(graphMouse.getModeMenu());
        panel.setCorner(menubar);
        this.vv.addKeyListener(graphMouse.getModeKeyListener());
        this.vv.setToolTipText("<html><center>Type 'p' for Pick mode<p>Type 't' for Transform mode");
        final CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scaler.scale(GraphFromGraphMLDemo.this.vv, 1.1f, GraphFromGraphMLDemo.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                scaler.scale(GraphFromGraphMLDemo.this.vv, 0.9090909f, GraphFromGraphMLDemo.this.vv.getCenter());
            }
        });
        JPanel controls = new JPanel();
        controls.add(plus);
        controls.add(minus);
        content.add((Component)controls, "South");
        frame.pack();
        frame.setVisible(true);
    }

    public static void main(String[] args) throws ParserConfigurationException, SAXException, IOException {
        String filename = "simple.graphml";
        if (args.length > 0) {
            filename = args[0];
        }
        new GraphFromGraphMLDemo(filename);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TestGraphMouseListener<V>
    implements GraphMouseListener<V> {
        TestGraphMouseListener() {
        }

        @Override
        public void graphClicked(V v, MouseEvent me) {
            System.err.println("Vertex " + v + " was clicked at (" + me.getX() + "," + me.getY() + ")");
        }

        @Override
        public void graphPressed(V v, MouseEvent me) {
            System.err.println("Vertex " + v + " was pressed at (" + me.getX() + "," + me.getY() + ")");
        }

        @Override
        public void graphReleased(V v, MouseEvent me) {
            System.err.println("Vertex " + v + " was released at (" + me.getX() + "," + me.getY() + ")");
        }
    }
}

