/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeType;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.map.LazyMap;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphMLFileHandler<V, E>
extends DefaultHandler {
    private Graph<V, E> mGraph;
    private Map<String, V> mLabeller;
    private EdgeType default_directed;
    private Factory<V> vertexFactory;
    private Factory<E> edgeFactory;
    private Factory<? extends Graph<V, E>> graphFactory;
    private Map<String, String> graphAttributes = new HashMap<String, String>();
    private Map<E, Map<String, String>> edgeAttributes = LazyMap.decorate(new HashMap(), new Factory<Map<String, String>>(){

        @Override
        public Map<String, String> create() {
            return new HashMap<String, String>();
        }
    });
    private Map<V, Map<String, String>> vertexAttributes = LazyMap.decorate(new HashMap(), new Factory<Map<String, String>>(){

        @Override
        public Map<String, String> create() {
            return new HashMap<String, String>();
        }
    });

    public GraphMLFileHandler(Factory<? extends Graph<V, E>> graphFactory, Factory<V> vertexFactory, Factory<E> edgeFactory) {
        this.graphFactory = graphFactory;
        this.vertexFactory = vertexFactory;
        this.edgeFactory = edgeFactory;
    }

    protected Graph<V, E> getGraph() {
        return this.mGraph;
    }

    protected Map<String, V> getLabeller() {
        return this.mLabeller;
    }

    private Map<String, String> getAttributeMap(Attributes attrs) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (attrs != null) {
            for (int i = 0; i < attrs.getLength(); ++i) {
                map.put(attrs.getQName(i), attrs.getValue(i));
            }
        }
        return map;
    }

    protected E createEdge(Map<String, String> attributeMap) {
        EdgeType directed;
        if (this.mGraph == null) {
            throw new RuntimeException("Error parsing graph. Graph element must be specified before edge element.");
        }
        String sourceId = attributeMap.remove("source");
        V sourceVertex = this.mLabeller.get(sourceId);
        String targetId = attributeMap.remove("target");
        V targetVertex = this.mLabeller.get(targetId);
        String direction = attributeMap.remove("directed");
        if (direction == null) {
            directed = this.default_directed;
        } else if (direction.equals("true")) {
            directed = EdgeType.DIRECTED;
        } else if (direction.equals("false")) {
            directed = EdgeType.UNDIRECTED;
        } else {
            throw new RuntimeException("Error parsing graph: 'directed' tag has invalid value: " + direction);
        }
        E e = this.edgeFactory.create();
        this.mGraph.addEdge(e, sourceVertex, targetVertex, directed);
        this.edgeAttributes.get(e).putAll(attributeMap);
        return e;
    }

    protected void createGraph(Map<String, String> attributeMap) {
        String edgeDefaultType = attributeMap.remove("edgedefault");
        this.mGraph = this.graphFactory.create();
        if (edgeDefaultType.equals("directed")) {
            this.default_directed = EdgeType.DIRECTED;
        } else if (edgeDefaultType.equals("undirected")) {
            this.default_directed = EdgeType.UNDIRECTED;
        } else {
            throw new RuntimeException("Error parsing graph. EdgeType default type not specified.");
        }
        this.mLabeller = new HashMap<String, V>();
        this.graphAttributes.putAll(attributeMap);
    }

    protected V createVertex(Map<String, String> attributeMap) {
        if (this.mGraph == null) {
            throw new RuntimeException("Error parsing graph. Graph element must be specified before node element.");
        }
        V vertex = this.vertexFactory.create();
        this.mGraph.addVertex(vertex);
        String idString = attributeMap.remove("id");
        if (this.mLabeller.put(idString, vertex) != null) {
            throw new RuntimeException("Ids must be unique");
        }
        this.vertexAttributes.get(vertex).putAll(attributeMap);
        return vertex;
    }

    @Override
    public void startElement(String namespaceURI, String lName, String qName, Attributes attrs) {
        Map<String, String> attributeMap = this.getAttributeMap(attrs);
        if (qName.toLowerCase().equals("graph")) {
            this.createGraph(attributeMap);
        } else if (qName.toLowerCase().equals("node")) {
            this.createVertex(attributeMap);
        } else if (qName.toLowerCase().equals("edge")) {
            this.createEdge(attributeMap);
        }
    }

    public Map<E, Map<String, String>> getEdgeAttributes() {
        return this.edgeAttributes;
    }

    public Map<String, String> getGraphAttributes() {
        return this.graphAttributes;
    }

    public Map<V, Map<String, String>> getVertexAttributes() {
        return this.vertexAttributes;
    }
}

