/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.layout;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Forest;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Tree;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.map.LazyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeLayout<V, E>
implements Layout<V, E> {
    private Dimension size = new Dimension(600, 600);
    private Forest<V, E> graph;
    protected Map<V, Integer> basePositions = new HashMap<V, Integer>();
    protected Map<V, Point2D> locations = LazyMap.decorate(new HashMap(), new Transformer<V, Point2D>(){

        @Override
        public Point2D transform(V arg0) {
            return new Point2D.Double();
        }
    });
    public static int DEFAULT_DISTX = 50;
    public static int DEFAULT_DISTY = 50;
    private transient Set<V> allreadyDone = new HashSet<V>();
    private int distX = DEFAULT_DISTX;
    private int distY = DEFAULT_DISTY;
    private transient Point m_currentPoint = new Point();
    private Collection<V> roots;

    public List<V> getAtomics(V p) {
        ArrayList v = new ArrayList();
        this.getAtomics(p, v);
        return v;
    }

    private void getAtomics(V p, List<V> v) {
        for (V c : this.graph.getSuccessors(p)) {
            if (this.graph.getSuccessors(c).size() == 0) {
                v.add(c);
                continue;
            }
            this.getAtomics(c, v);
        }
    }

    public TreeLayout(Forest<V, E> g) {
        this(g, DEFAULT_DISTX, DEFAULT_DISTY);
    }

    public TreeLayout(Forest<V, E> g, int distx) {
        this(g, distx, DEFAULT_DISTY);
    }

    public TreeLayout(Forest<V, E> g, int distx, int disty) {
        this.graph = g;
        this.roots = this.getRoots(g);
        this.distX = distx;
        this.distY = disty;
        this.buildTree();
    }

    private Collection<V> getRoots(Forest<V, E> forest) {
        HashSet<V> roots = new HashSet<V>();
        for (Tree<V, E> tree : forest.getTrees()) {
            roots.add(tree.getRoot());
        }
        return roots;
    }

    public Dimension getCurrentSize() {
        return this.size;
    }

    void buildTree() {
        this.m_currentPoint = new Point(0, 20);
        if (this.roots.size() > 0 && this.graph != null) {
            this.calculateDimensionX(this.roots);
            for (V v : this.roots) {
                this.calculateDimensionX(v);
                this.m_currentPoint.x += this.basePositions.get(v) / 2 + 50;
                this.buildTree(v, this.m_currentPoint.x);
            }
        }
        int width = 0;
        for (V v : this.roots) {
            width += this.basePositions.get(v).intValue();
        }
    }

    void buildTree(V v, int x) {
        if (!this.allreadyDone.contains(v)) {
            this.allreadyDone.add(v);
            this.m_currentPoint.y += this.distY;
            this.m_currentPoint.x = x;
            this.setCurrentPositionFor(v);
            int sizeXofCurrent = this.basePositions.get(v);
            int lastX = x - sizeXofCurrent / 2;
            for (V element : this.graph.getSuccessors(v)) {
                int sizeXofChild = this.basePositions.get(element);
                int startXofChild = lastX + sizeXofChild / 2;
                this.buildTree(element, startXofChild);
                lastX = lastX + sizeXofChild + this.distX;
            }
            this.m_currentPoint.y -= this.distY;
        }
    }

    private int calculateDimensionX(V v) {
        int size = 0;
        int childrenNum = this.graph.getSuccessors(v).size();
        if (childrenNum != 0) {
            for (V element : this.graph.getSuccessors(v)) {
                size += this.calculateDimensionX(element) + this.distX;
            }
        }
        size = Math.max(0, size - this.distX);
        this.basePositions.put((Integer)v, size);
        return size;
    }

    private int calculateDimensionX(Collection<V> roots) {
        int size = 0;
        for (V v : roots) {
            int childrenNum = this.graph.getSuccessors(v).size();
            if (childrenNum != 0) {
                for (V element : this.graph.getSuccessors(v)) {
                    size += this.calculateDimensionX(element) + this.distX;
                }
            }
            size = Math.max(0, size - this.distX);
            this.basePositions.put((Integer)v, size);
        }
        return size;
    }

    public int getDepth(V v) {
        int depth = 0;
        for (V c : this.graph.getSuccessors(v)) {
            if (this.graph.getSuccessors(c).size() == 0) {
                depth = 0;
                continue;
            }
            depth = Math.max(depth, this.getDepth(c));
        }
        return depth + 1;
    }

    @Override
    public void setSize(Dimension size) {
    }

    private void setCurrentPositionFor(V vertex) {
        int x = this.m_currentPoint.x;
        int y = this.m_currentPoint.y;
        if (x < 0) {
            this.size.width -= x;
        }
        if (x > this.size.width - this.distX) {
            this.size.width = x + this.distX;
        }
        if (y < 0) {
            this.size.height -= y;
        }
        if (y > this.size.height - this.distY) {
            this.size.height = y + this.distY;
        }
        this.locations.get(vertex).setLocation(this.m_currentPoint);
    }

    @Override
    public Graph<V, E> getGraph() {
        return this.graph;
    }

    @Override
    public Dimension getSize() {
        return this.size;
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean isLocked(V v) {
        return false;
    }

    @Override
    public void lock(V v, boolean state) {
    }

    @Override
    public void reset() {
    }

    @Override
    public void setGraph(Graph<V, E> graph) {
        if (!(graph instanceof Forest)) {
            throw new IllegalArgumentException("graph must be a Forest");
        }
        this.graph = (Forest)graph;
        this.buildTree();
    }

    @Override
    public void setInitializer(Transformer<V, Point2D> initializer) {
    }

    public Point2D getCenter() {
        return new Point2D.Double(this.size.getWidth() / 2.0, this.size.getHeight() / 2.0);
    }

    @Override
    public void setLocation(V v, Point2D location) {
        this.locations.get(v).setLocation(location);
    }

    @Override
    public Point2D transform(V v) {
        return this.locations.get(v);
    }
}

