/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.layout;

import edu.uci.ics.jung.algorithms.layout.AbstractLayout;
import edu.uci.ics.jung.algorithms.util.IterativeContext;
import edu.uci.ics.jung.algorithms.util.RandomLocationTransformer;
import edu.uci.ics.jung.graph.Graph;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Point2D;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.map.LazyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpringLayout2<V, E>
extends AbstractLayout<V, E>
implements IterativeContext {
    protected double stretch = 0.7;
    protected LengthFunction<E> lengthFunction;
    protected int repulsion_range = 10000;
    protected double force_multiplier = 0.3333333333333333;
    protected int currentIteration;
    protected int averageCounter;
    protected int loopCountMax = 4;
    protected boolean done;
    protected Point2D averageDelta = new Point2D.Double();
    Map<E, SpringEdgeData<E>> springEdgeData = LazyMap.decorate(new HashMap(), new Transformer<E, SpringEdgeData<E>>(){

        @Override
        public SpringEdgeData<E> transform(E e) {
            return new SpringEdgeData(e);
        }
    });
    Map<V, SpringVertexData> springVertexData = LazyMap.decorate(new HashMap(), new Factory<SpringVertexData>(){

        @Override
        public SpringVertexData create() {
            return new SpringVertexData();
        }
    });
    public static final LengthFunction UNITLENGTHFUNCTION = new UnitLengthFunction(30);

    public SpringLayout2(Graph<V, E> g) {
        this(g, UNITLENGTHFUNCTION);
    }

    public SpringLayout2(Graph<V, E> g, LengthFunction<E> f) {
        super(g);
        this.lengthFunction = f;
    }

    public double getStretch() {
        return this.stretch;
    }

    @Override
    public void setSize(Dimension size) {
        if (!this.initialized) {
            this.setInitializer(new RandomLocationTransformer(size));
        }
        super.setSize(size);
    }

    public void setStretch(double stretch) {
        this.stretch = stretch;
    }

    public int getRepulsionRange() {
        return this.repulsion_range;
    }

    public void setRepulsionRange(int range) {
        this.repulsion_range = range;
    }

    public double getForceMultiplier() {
        return this.force_multiplier;
    }

    public void setForceMultiplier(double force) {
        this.force_multiplier = force;
    }

    @Override
    public void initialize() {
        Graph graph = this.getGraph();
        Dimension d = this.getSize();
        if (graph != null && d != null) {
            try {
                for (Object e : graph.getEdges()) {
                    SpringEdgeData sed = this.getSpringData((E)e);
                    this.calcEdgeLength(sed, this.lengthFunction);
                }
            }
            catch (ConcurrentModificationException cme) {
                this.initialize();
            }
        }
    }

    protected void calcEdgeLength(SpringEdgeData<E> sed, LengthFunction<E> f) {
        sed.length = f.getLength(sed.e);
    }

    @Override
    public void step() {
        try {
            for (Object v : this.getGraph().getVertices()) {
                SpringVertexData svd = this.getSpringData((V)v);
                if (svd == null) continue;
                svd.dx /= 4.0;
                svd.dy /= 4.0;
                svd.edgedy = 0.0;
                svd.edgedx = 0.0;
                svd.repulsiondy = 0.0;
                svd.repulsiondx = 0.0;
            }
        }
        catch (ConcurrentModificationException cme) {
            this.step();
        }
        this.relaxEdges();
        this.calculateRepulsion();
        this.moveNodes();
        ++this.currentIteration;
        this.testAverageDeltas();
    }

    private void testAverageDeltas() {
        double dx = this.averageDelta.getX();
        double dy = this.averageDelta.getY();
        if (Math.abs(dx) < 0.001 && Math.abs(dy) < 0.001) {
            this.done = true;
            System.err.println("done, dx=" + dx + ", dy=" + dy);
        }
        if (this.currentIteration > this.loopCountMax) {
            this.averageDelta.setLocation(0.0, 0.0);
            this.averageCounter = 0;
            this.currentIteration = 0;
        }
    }

    protected V getAVertex(E e) {
        return this.getGraph().getIncidentVertices(e).iterator().next();
    }

    protected void relaxEdges() {
        try {
            for (Object e : this.getGraph().getEdges()) {
                V v1 = this.getAVertex(e);
                Object v2 = this.getGraph().getOpposite(v1, e);
                Object p1 = this.transform((Object)v1);
                Object p2 = this.transform(v2);
                if (p1 == null || p2 == null) continue;
                double vx = ((Point2D)p1).getX() - ((Point2D)p2).getX();
                double vy = ((Point2D)p1).getY() - ((Point2D)p2).getY();
                double len = Math.sqrt(vx * vx + vy * vy);
                SpringEdgeData sed = this.getSpringData((E)e);
                if (sed == null) continue;
                double desiredLen = sed.length;
                len = len == 0.0 ? 1.0E-4 : len;
                double f = this.force_multiplier * (desiredLen - len) / len;
                double dx = (f *= Math.pow(this.stretch, this.getGraph().degree(v1) + this.getGraph().degree(v2) - 2)) * vx;
                double dy = f * vy;
                SpringVertexData v1D = this.getSpringData(v1);
                SpringVertexData v2D = this.getSpringData((V)v2);
                sed.f = f;
                v1D.edgedx += dx;
                v1D.edgedy += dy;
                v2D.edgedx += -dx;
                v2D.edgedy += -dy;
            }
        }
        catch (ConcurrentModificationException cme) {
            this.relaxEdges();
        }
    }

    protected void calculateRepulsion() {
        try {
            for (Object v : this.getGraph().getVertices()) {
                SpringVertexData svd;
                if (this.isLocked(v) || (svd = this.getSpringData((V)v)) == null) continue;
                double dx = 0.0;
                double dy = 0.0;
                for (Object v2 : this.getGraph().getVertices()) {
                    if (v == v2) continue;
                    Object p = this.transform(v);
                    Object p2 = this.transform(v2);
                    if (p == null || p2 == null) continue;
                    double vx = ((Point2D)p).getX() - ((Point2D)p2).getX();
                    double vy = ((Point2D)p).getY() - ((Point2D)p2).getY();
                    double distanceSq = ((Point2D)p).distanceSq((Point2D)p2);
                    if (distanceSq == 0.0) {
                        dx += Math.random();
                        dy += Math.random();
                        continue;
                    }
                    if (!(distanceSq < (double)this.repulsion_range)) continue;
                    double factor = 1.0;
                    dx += factor * vx / distanceSq;
                    dy += factor * vy / distanceSq;
                }
                double dlen = dx * dx + dy * dy;
                if (!(dlen > 0.0)) continue;
                dlen = Math.sqrt(dlen) / 2.0;
                svd.repulsiondx += dx / dlen;
                svd.repulsiondy += dy / dlen;
            }
        }
        catch (ConcurrentModificationException cme) {
            this.calculateRepulsion();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveNodes() {
        Dimension dimension = this.getSize();
        synchronized (dimension) {
            try {
                for (Object v : this.getGraph().getVertices()) {
                    SpringVertexData vd;
                    if (this.isLocked(v) || (vd = this.getSpringData((V)v)) == null) continue;
                    Object xyd = this.transform(v);
                    vd.dx += vd.repulsiondx + vd.edgedx;
                    vd.dy += vd.repulsiondy + vd.edgedy;
                    this.averageDelta.setLocation((this.averageDelta.getX() * (double)this.averageCounter + vd.dx) / (double)(this.averageCounter + 1), (this.averageDelta.getY() * (double)this.averageCounter + vd.dy) / (double)(this.averageCounter + 1));
                    ++this.averageCounter;
                    ((Point2D)xyd).setLocation(((Point2D)xyd).getX() + Math.max(-5.0, Math.min(5.0, vd.dx)), ((Point2D)xyd).getY() + Math.max(-5.0, Math.min(5.0, vd.dy)));
                    Dimension d = this.getSize();
                    int width = d.width;
                    int height = d.height;
                    if (((Point2D)xyd).getX() < 0.0) {
                        ((Point2D)xyd).setLocation(0.0, ((Point2D)xyd).getY());
                    } else if (((Point2D)xyd).getX() > (double)width) {
                        ((Point2D)xyd).setLocation(width, ((Point2D)xyd).getY());
                    }
                    if (((Point2D)xyd).getY() < 0.0) {
                        ((Point2D)xyd).setLocation(((Point2D)xyd).getX(), 0.0);
                        continue;
                    }
                    if (!(((Point2D)xyd).getY() > (double)height)) continue;
                    ((Point2D)xyd).setLocation(((Point2D)xyd).getX(), height);
                }
            }
            catch (ConcurrentModificationException cme) {
                this.moveNodes();
            }
        }
    }

    public SpringVertexData getSpringData(V v) {
        return this.springVertexData.get(v);
    }

    public SpringEdgeData<E> getSpringData(E e) {
        return this.springEdgeData.get(e);
    }

    public double getLength(E e) {
        return this.springEdgeData.get(e).length;
    }

    public boolean isIncremental() {
        return true;
    }

    @Override
    public boolean done() {
        return this.done;
    }

    @Override
    public void reset() {
    }

    public class SpringDimensionChecker
    extends ComponentAdapter {
        public void componentResized(ComponentEvent e) {
            SpringLayout2.this.setSize(e.getComponent().getSize());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class SpringEdgeData<E> {
        public double f;
        E e;
        double length;

        public SpringEdgeData(E e) {
            this.e = e;
        }
    }

    protected static class SpringVertexData {
        public double edgedx;
        public double edgedy;
        public double repulsiondx;
        public double repulsiondy;
        public double dx;
        public double dy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class UnitLengthFunction<E>
    implements LengthFunction<E> {
        int length;

        public UnitLengthFunction(int length) {
            this.length = length;
        }

        @Override
        public double getLength(E e) {
            return this.length;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface LengthFunction<E> {
        public double getLength(E var1);
    }
}

