/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.layout;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.PolarPoint;
import edu.uci.ics.jung.graph.Forest;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Tree;
import java.awt.Dimension;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.map.LazyMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BalloonLayout<V, E>
implements Layout<V, E> {
    private Dimension size;
    private Graph<V, E> graph;
    protected Map<V, Point2D> locations = LazyMap.decorate(new HashMap(), new Transformer<V, Point2D>(){

        @Override
        public Point2D transform(V arg0) {
            return new Point2D.Double(BalloonLayout.this.size.getWidth() / 2.0, BalloonLayout.this.size.getHeight() / 2.0);
        }
    });
    protected Map<V, PolarPoint> polarLocations = LazyMap.decorate(new HashMap(), new Transformer<V, PolarPoint>(){

        @Override
        public PolarPoint transform(V arg0) {
            return new PolarPoint();
        }
    });
    protected Map<V, Double> radii = new HashMap<V, Double>();
    private Collection<V> roots;

    public BalloonLayout(Forest<V, E> g) {
        this.graph = g;
        this.roots = this.getRoots(g);
    }

    public BalloonLayout(Tree<V, E> g) {
        this.graph = g;
        this.roots = new ArrayList<V>(1);
        this.roots.add(g.getRoot());
    }

    private Collection<V> getRoots(Graph<V, E> graph) {
        HashSet roots = new HashSet();
        for (Object v : graph.getVertices()) {
            if (graph.getPredecessors(v).size() != 0) continue;
            roots.add(v);
        }
        return roots;
    }

    protected void setRootPolars(List<V> roots) {
        if (roots.size() != 0) {
            if (roots.size() == 1) {
                V root = roots.get(0);
                this.setRootPolar(root);
                this.setPolars(new ArrayList<V>(this.getChildren(root)), this.getCenter(), this.getSize().width / 2);
            } else {
                this.setPolars(roots, this.getCenter(), this.getSize().width / 2);
            }
        }
    }

    protected void setRootPolar(V root) {
        PolarPoint pp = new PolarPoint(0.0, 0.0);
        Point2D p = this.getCenter();
        this.polarLocations.put((PolarPoint)root, pp);
        this.locations.put((Point2D)root, p);
    }

    protected void setPolars(List<V> kids, Point2D parentLocation, double parentRadius) {
        int childCount = kids.size();
        if (childCount == 0) {
            return;
        }
        double angle = Math.max(0.0, 1.5707963267948966 * (1.0 - 2.0 / (double)childCount));
        double childRadius = parentRadius * Math.cos(angle) / (1.0 + Math.cos(angle));
        double radius = parentRadius - childRadius;
        double rand = Math.random();
        for (int i = 0; i < childCount; ++i) {
            V child = kids.get(i);
            double theta = (double)(i * 2) * Math.PI / (double)childCount + rand;
            this.radii.put((Double)child, childRadius);
            PolarPoint pp = new PolarPoint(theta, radius);
            this.polarLocations.put((PolarPoint)child, pp);
            Point2D p = PolarPoint.polarToCartesian(pp);
            p.setLocation(p.getX() + parentLocation.getX(), p.getY() + parentLocation.getY());
            this.locations.put((Point2D)child, p);
            this.setPolars(new ArrayList<V>(this.getChildren(child)), p, childRadius);
        }
    }

    @Override
    public void setSize(Dimension size) {
        this.size = size;
        this.setRootPolars(new ArrayList<V>(this.roots));
    }

    @Override
    public Graph<V, E> getGraph() {
        return this.graph;
    }

    @Override
    public Dimension getSize() {
        return this.size;
    }

    @Override
    public void initialize() {
    }

    @Override
    public boolean isLocked(V v) {
        return false;
    }

    @Override
    public void lock(V v, boolean state) {
    }

    @Override
    public void reset() {
    }

    @Override
    public void setGraph(Graph<V, E> graph) {
        this.graph = graph;
    }

    @Override
    public void setInitializer(Transformer<V, Point2D> initializer) {
    }

    public Point2D getCenter() {
        return new Point2D.Double(this.size.getWidth() / 2.0, this.size.getHeight() / 2.0);
    }

    public Point2D getCenter(V v) {
        V parent = this.getParent(v);
        if (parent == null) {
            return this.getCenter();
        }
        return this.locations.get(parent);
    }

    @Override
    public void setLocation(V v, Point2D location) {
        Point2D c = this.getCenter(v);
        Point2D.Double pv = new Point2D.Double(location.getX() - c.getX(), location.getY() - c.getY());
        PolarPoint newLocation = PolarPoint.cartesianToPolar(pv);
        this.polarLocations.get(v).setLocation(newLocation);
        Point2D center = this.getCenter(v);
        ((Point2D)pv).setLocation(((Point2D)pv).getX() + center.getX(), ((Point2D)pv).getY() + center.getY());
        this.locations.put((Point2D)v, pv);
    }

    @Override
    public Point2D transform(V v) {
        return this.locations.get(v);
    }

    private V getParent(V v) {
        return this.graph.getPredecessorCount(v) == 1 ? (V)this.graph.getPredecessors(v).iterator().next() : null;
    }

    private Collection<V> getChildren(V parent) {
        return this.graph.getSuccessors(parent);
    }

    public Map<V, Double> getRadii() {
        return this.radii;
    }
}

