/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.importance;

import edu.uci.ics.jung.algorithms.importance.RelativeAuthorityRanker;
import edu.uci.ics.jung.algorithms.util.NumericalPrecision;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageRank<V, E>
extends RelativeAuthorityRanker<V, E> {
    public static final String KEY = "jung.algorithms.importance.PageRank.RankScore";
    private double mAlpha;
    private final HashMap<V, Number> mPreviousRankingsMap = new HashMap();
    private final Set<V> mUnreachableVertices = new HashSet<V>();
    private final Set<V> mReachableVertices = new HashSet<V>();
    private final Set<V> mLeafNodes = new HashSet<V>();

    public PageRank(DirectedGraph<V, E> graph, double bias) {
        this.initialize(graph, bias, null);
        this.initializeRankings(graph.getVertices(), new HashSet());
    }

    public PageRank(DirectedGraph<V, E> graph, double bias, Map<E, Number> edgeWeights) {
        this.initialize(graph, bias, edgeWeights);
        this.initializeRankings(graph.getVertices(), new HashSet());
    }

    protected PageRank(DirectedGraph<V, E> graph, double bias, Map<E, Number> edgeWeights, Pair<Set<V>> reachables) {
        this.initialize(graph, bias, edgeWeights);
        this.initializeRankings((Collection)reachables.getFirst(), (Collection)reachables.getSecond());
    }

    protected void initialize(DirectedGraph<V, E> graph, double bias, Map<E, Number> edgeWeights) {
        super.initialize(graph, true, false);
        if (bias < 0.0 || bias > 1.0) {
            throw new IllegalArgumentException("Bias " + bias + " must be between 0 and 1.");
        }
        this.mAlpha = bias;
        if (edgeWeights == null) {
            this.assignDefaultEdgeTransitionWeights();
        } else {
            this.setEdgeWeights(edgeWeights);
            this.normalizeEdgeTransitionWeights();
        }
    }

    protected void initializeRankings(Collection<V> reachableVertices, Collection<V> unreachableVertices) {
        this.mReachableVertices.clear();
        this.mReachableVertices.addAll(reachableVertices);
        double numVertices = reachableVertices.size();
        this.mPreviousRankingsMap.clear();
        this.mLeafNodes.clear();
        for (V currentVertex : this.mReachableVertices) {
            this.setVertexRankScore(currentVertex, 1.0 / numVertices);
            this.setPriorRankScore(currentVertex, 1.0 / numVertices);
            this.mPreviousRankingsMap.put((Number)currentVertex, new Double(1.0 / numVertices));
            if (this.getGraph().outDegree(currentVertex) != 0) continue;
            this.mLeafNodes.add(currentVertex);
        }
        this.mUnreachableVertices.clear();
        this.mUnreachableVertices.addAll(unreachableVertices);
        for (V currentVertex : this.mUnreachableVertices) {
            this.setVertexRankScore(currentVertex, 0.0);
            this.setPriorRankScore(currentVertex, 0.0);
            this.mPreviousRankingsMap.put((Number)currentVertex, new Double(0.0));
        }
    }

    @Override
    public void reset() {
        this.initializeRankings(this.mReachableVertices, this.mUnreachableVertices);
    }

    protected void updateRankings() {
        double totalSum = 0.0;
        for (V currentVertex : this.mReachableVertices) {
            double currentWeight;
            Collection incomingEdges = this.getGraph().getInEdges(currentVertex);
            double currentPageRankSum = 0.0;
            for (Object incomingEdge : incomingEdges) {
                if (this.mUnreachableVertices.contains(this.getGraph().getOpposite(currentVertex, incomingEdge))) continue;
                currentWeight = this.getEdgeWeight(incomingEdge);
                currentPageRankSum += this.mPreviousRankingsMap.get(this.getGraph().getOpposite(currentVertex, incomingEdge)).doubleValue() * currentWeight;
            }
            if (this.getPriorRankScore(currentVertex) > 0.0) {
                for (Object leafNode : this.mLeafNodes) {
                    currentWeight = this.getPriorRankScore(currentVertex);
                    currentPageRankSum += this.mPreviousRankingsMap.get(leafNode).doubleValue() * currentWeight;
                }
            }
            totalSum += currentPageRankSum * (1.0 - this.mAlpha) + this.mAlpha * this.getPriorRankScore(currentVertex);
            this.setVertexRankScore(currentVertex, currentPageRankSum * (1.0 - this.mAlpha) + this.mAlpha * this.getPriorRankScore(currentVertex));
        }
        if (!NumericalPrecision.equal(totalSum, 1.0, 0.05)) {
            System.err.println("Page rank scores can not be generated because the specified graph is not connected.");
            System.out.println(totalSum);
        }
    }

    @Override
    public void step() {
        this.updateRankings();
        double rankingMSE = 0.0;
        for (V currentVertex : this.mReachableVertices) {
            double previousRankScore = this.mPreviousRankingsMap.get(currentVertex).doubleValue();
            rankingMSE += Math.pow(this.getVertexRankScore(currentVertex) - previousRankScore, 2.0);
            this.mPreviousRankingsMap.put((Number)currentVertex, this.getVertexRankScore(currentVertex));
        }
        rankingMSE = Math.pow(rankingMSE / (double)this.getVertexCount(), 0.5);
        this.setPrecision(rankingMSE);
    }

    @Override
    public String getRankScoreKey() {
        return KEY;
    }
}

