/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.importance;

import edu.uci.ics.jung.algorithms.cluster.WeakComponentClusterer;
import edu.uci.ics.jung.algorithms.importance.RelativeAuthorityRanker;
import edu.uci.ics.jung.graph.Graph;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HITSWithPriors<V, E>
extends RelativeAuthorityRanker<V, E> {
    protected static final String AUTHORITY_KEY = "jung.algorithms.importance.AUTHORITY";
    protected static final String HUB_KEY = "jung.algorithms.importance.HUB";
    private String mKeyToUseForRanking;
    private Map<V, Number> mPreviousAuthorityScores;
    private Map<V, Number> mPreviousHubScores;
    private double mBeta;
    Set<V> mReachableVertices;
    private Set<V> mLeafNodes;
    private Map<E, Number> inEdgeWeights = new HashMap<E, Number>();

    public HITSWithPriors(Graph<V, E> graph, double bias, Set<V> priors) {
        this.mKeyToUseForRanking = AUTHORITY_KEY;
        this.mBeta = bias;
        this.setPriors(priors);
        this.initialize(graph, null);
    }

    public HITSWithPriors(Graph<V, E> graph, boolean useAuthorityForRanking, double bias, Set<V> priors, String edgeWeightKey) {
        this.setUseAuthorityForRanking(useAuthorityForRanking);
        this.mBeta = bias;
        this.setPriors(priors);
        this.initialize(graph, edgeWeightKey);
    }

    protected void initialize(Graph<V, E> g, String edgeWeightKeyName) {
        super.initialize(g, true, false);
        this.mPreviousAuthorityScores = new HashMap<V, Number>();
        this.mPreviousHubScores = new HashMap<V, Number>();
        for (Object v : g.getVertices()) {
            this.mPreviousAuthorityScores.put((Number)v, 0);
            this.mPreviousHubScores.put((Number)v, 0);
            this.setVertexRankScore(v, 0.0, AUTHORITY_KEY);
            this.setVertexRankScore(v, 0.0, HUB_KEY);
            this.setPriorRankScore(v, 0.0);
        }
        WeakComponentClusterer<V, E> wcExtractor = new WeakComponentClusterer<V, E>();
        Set clusters = wcExtractor.transform(g);
        this.mReachableVertices = new HashSet<V>();
        double numPriors = this.getPriors().size();
        for (Object v : this.getPriors()) {
            this.setPriorRankScore(v, 1.0 / numPriors);
            for (Set members : clusters) {
                if (!members.contains(v)) continue;
                this.mReachableVertices.addAll(members);
            }
        }
        this.mLeafNodes = new HashSet<V>();
        int numReachableVertices = this.mReachableVertices.size();
        for (V v : this.mReachableVertices) {
            this.setVertexRankScore(v, 1.0 / (double)numReachableVertices, AUTHORITY_KEY);
            this.setVertexRankScore(v, 1.0 / (double)numReachableVertices, HUB_KEY);
            if (this.getGraph().outDegree(v) != 0) continue;
            this.mLeafNodes.add(v);
        }
        if (edgeWeightKeyName == null) {
            this.assignDefaultEdgeTransitionWeights();
        } else {
            this.setEdgeWeights(this.inEdgeWeights);
            this.normalizeEdgeTransitionWeights();
        }
        this.assignInlinkEdgeTransitionWeights();
    }

    private void normalizeRankings(double normConstant, Object key) {
        for (Object v : this.getVertices()) {
            double rankScore = this.getVertexRankScore(v, key);
            this.setVertexRankScore(v, rankScore / normConstant, key);
        }
    }

    @Override
    protected void finalizeIterations() {
        super.finalizeIterations();
        for (Object v : this.getVertices()) {
            if (this.mKeyToUseForRanking.equals(AUTHORITY_KEY)) {
                super.removeVertexRankScore(v, HUB_KEY);
                continue;
            }
            super.removeVertexRankScore(v, AUTHORITY_KEY);
        }
    }

    protected double getInEdgeWeight(E e) {
        return this.inEdgeWeights.get(e).doubleValue();
    }

    protected void setInEdgeWeight(E e, double weight) {
        this.inEdgeWeights.put(e, weight);
    }

    private void assignInlinkEdgeTransitionWeights() {
        for (Object v : this.getVertices()) {
            Collection incomingEdges = this.getGraph().getInEdges(v);
            double total = 0.0;
            for (Object e : incomingEdges) {
                total += this.getEdgeWeight(e);
            }
            for (Object e : incomingEdges) {
                double weight = this.getEdgeWeight(e);
                this.setInEdgeWeight(e, weight / total);
            }
        }
    }

    @Override
    public String getRankScoreKey() {
        return this.mKeyToUseForRanking;
    }

    protected double getPreviousAuthorityScore(V v) {
        return this.mPreviousAuthorityScores.get(v).doubleValue();
    }

    protected double getPreviousHubScore(V v) {
        return this.mPreviousHubScores.get(v).doubleValue();
    }

    @Override
    public void step() {
        this.updatePreviousScores();
        this.updateAuthorityRankings();
        this.updateHubRankings();
        double hubMSE = 0.0;
        double authorityMSE = 0.0;
        int numVertices = this.mReachableVertices.size();
        for (V v : this.mReachableVertices) {
            double currentAuthorityScore = this.getVertexRankScore(v, AUTHORITY_KEY);
            double currentHubScore = this.getVertexRankScore(v, HUB_KEY);
            double previousAuthorityScore = this.getPreviousAuthorityScore(v);
            double previousHubScore = this.getPreviousHubScore(v);
            hubMSE += Math.pow(currentHubScore - previousHubScore, 2.0);
            authorityMSE += Math.pow(currentAuthorityScore - previousAuthorityScore, 2.0);
        }
        hubMSE = Math.pow(hubMSE / (double)numVertices, 0.5);
        authorityMSE = Math.pow(authorityMSE / (double)numVertices, 0.5);
        this.setPrecision(hubMSE + authorityMSE);
    }

    public void setUseAuthorityForRanking(boolean useAuthorityForRanking) {
        this.mKeyToUseForRanking = useAuthorityForRanking ? AUTHORITY_KEY : HUB_KEY;
    }

    private double computeSum(V v, String key) {
        double currentWeight;
        Collection edges = null;
        String oppositeKey = null;
        if (key.equals(HUB_KEY)) {
            edges = this.getGraph().getOutEdges(v);
            oppositeKey = AUTHORITY_KEY;
        } else {
            edges = this.getGraph().getInEdges(v);
            oppositeKey = HUB_KEY;
        }
        double sum = 0.0;
        for (Object e : edges) {
            currentWeight = 1.0;
            sum += this.getVertexRankScore(this.getGraph().getOpposite(v, e), oppositeKey) * currentWeight;
        }
        if (this.getPriorRankScore(v) > 0.0 && key.equals(AUTHORITY_KEY)) {
            for (Object leafNode : this.mLeafNodes) {
                currentWeight = this.getPriorRankScore(v);
                sum += this.getVertexRankScore(leafNode, oppositeKey) * currentWeight;
            }
        }
        return sum;
    }

    protected void updateAuthorityRankings() {
        double authoritySum = 0.0;
        double total = 0.0;
        for (V v : this.mReachableVertices) {
            double newAuthorityScore = this.computeSum(v, AUTHORITY_KEY) * (1.0 - this.mBeta) + this.mBeta * this.getPriorRankScore(v);
            authoritySum += newAuthorityScore;
            total += newAuthorityScore * newAuthorityScore;
            this.setVertexRankScore(v, newAuthorityScore, AUTHORITY_KEY);
        }
        this.normalizeRankings(Math.sqrt(total), AUTHORITY_KEY);
    }

    protected void updateHubRankings() {
        double hubSum = 0.0;
        double total = 0.0;
        for (V v : this.mReachableVertices) {
            double newHubScore = this.computeSum(v, HUB_KEY) * (1.0 - this.mBeta) + this.mBeta * this.getPriorRankScore(v);
            hubSum += newHubScore;
            total += newHubScore * newHubScore;
            this.setVertexRankScore(v, newHubScore, HUB_KEY);
        }
        this.normalizeRankings(Math.sqrt(total), HUB_KEY);
    }

    protected void updatePreviousScores() {
        for (Object v : this.getVertices()) {
            this.mPreviousAuthorityScores.put((Number)v, this.getVertexRankScore(v, AUTHORITY_KEY));
            this.mPreviousHubScores.put((Number)v, this.getVertexRankScore(v, HUB_KEY));
        }
    }
}

