/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.importance;

import edu.uci.ics.jung.algorithms.importance.AbstractRanker;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Graph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DegreeDistributionRanker<V, E>
extends AbstractRanker<V, E> {
    public static final String KEY = "jung.algorithms.importance.DegreeDistributionRanker.RankScore";
    private boolean mUseInDegree;
    private boolean directed;

    public DegreeDistributionRanker(Graph<V, E> graph) {
        this(graph, true);
    }

    public DegreeDistributionRanker(Graph<V, E> graph, boolean useInDegree) {
        this.initialize(graph, true, false);
        this.mUseInDegree = useInDegree;
        this.directed = this.getGraph() instanceof DirectedGraph;
    }

    @Override
    public void step() {
        for (Object currentVertex : this.getVertices()) {
            if (this.directed) {
                if (this.mUseInDegree) {
                    this.setVertexRankScore(currentVertex, this.getGraph().inDegree(currentVertex));
                    continue;
                }
                this.setVertexRankScore(currentVertex, this.getGraph().outDegree(currentVertex));
                continue;
            }
            this.setVertexRankScore(currentVertex, this.getGraph().degree(currentVertex));
        }
        this.normalizeRankings();
    }

    @Override
    public String getRankScoreKey() {
        return KEY;
    }
}

