/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.importance;

import edu.uci.ics.jung.algorithms.importance.AbstractRanker;
import edu.uci.ics.jung.algorithms.shortestpath.DijkstraDistance;
import edu.uci.ics.jung.graph.Graph;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaryCenter<V, E>
extends AbstractRanker<V, E> {
    public static final String KEY = "edu.uci.ics.jung.algorithms.importance.BaryCenter.RankScore";

    public BaryCenter(Graph<V, E> g) {
        this.initialize(g, true, false);
    }

    @Override
    public void step() {
        DijkstraDistance p = new DijkstraDistance(this.getGraph());
        for (Object u : this.getVertices()) {
            double baryCenter = 0.0;
            Iterator<Number> j = p.getDistanceMap(u).values().iterator();
            while (j.hasNext()) {
                baryCenter += j.next().doubleValue();
            }
            this.setVertexRankScore(u, baryCenter);
        }
    }

    @Override
    public String getRankScoreKey() {
        return KEY;
    }
}

