/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.generators.random;

import edu.uci.ics.jung.algorithms.generators.EvolvingGraphGenerator;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.collections15.Factory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarabasiAlbertGenerator<V, E>
implements EvolvingGraphGenerator<V, E> {
    private Graph<V, E> mGraph = null;
    private int mNumEdgesToAttachPerStep;
    private int mElapsedTimeSteps;
    private Random mRandom;
    protected List<V> vertex_index;
    protected int init_vertices;
    protected Map<V, Integer> index_vertex;
    protected boolean directed;
    protected boolean parallel;
    protected Factory<Graph<V, E>> graphFactory;
    protected Factory<V> vertexFactory;
    protected Factory<E> edgeFactory;

    public BarabasiAlbertGenerator(Factory<Graph<V, E>> graphFactory, Factory<V> vertexFactory, Factory<E> edgeFactory, int init_vertices, int numEdgesToAttach, boolean directed, boolean parallel, int seed, Set<V> seedVertices) {
        assert (init_vertices > 0) : "Number of initial unconnected 'seed' vertices must be positive";
        assert (numEdgesToAttach > 0) : "Number of edges to attach at each time step must be positive";
        if (!parallel && init_vertices < numEdgesToAttach) {
            throw new IllegalArgumentException("If parallel edges disallowed, initialnumber of vertices must be >= number of edges to attach at each time step");
        }
        this.mNumEdgesToAttachPerStep = numEdgesToAttach;
        this.mRandom = new Random(seed);
        this.graphFactory = graphFactory;
        this.vertexFactory = vertexFactory;
        this.edgeFactory = edgeFactory;
        this.init_vertices = init_vertices;
        this.directed = directed;
        this.parallel = parallel;
        this.initialize(seedVertices);
    }

    public BarabasiAlbertGenerator(Factory<Graph<V, E>> graphFactory, Factory<V> vertexFactory, Factory<E> edgeFactory, int init_vertices, int numEdgesToAttach, int seed, Set<V> seedVertices) {
        this(graphFactory, vertexFactory, edgeFactory, init_vertices, numEdgesToAttach, false, false, seed, seedVertices);
    }

    public BarabasiAlbertGenerator(Factory<Graph<V, E>> graphFactory, Factory<V> vertexFactory, Factory<E> edgeFactory, int init_vertices, int numEdgesToAttach, Set<V> seedVertices) {
        this(graphFactory, vertexFactory, edgeFactory, init_vertices, numEdgesToAttach, (int)System.currentTimeMillis(), seedVertices);
    }

    private void initialize(Set<V> seedVertices) {
        this.mGraph = this.graphFactory.create();
        this.vertex_index = new ArrayList<V>(2 * this.init_vertices);
        this.index_vertex = new HashMap<V, Integer>(2 * this.init_vertices);
        for (int i = 0; i < this.init_vertices; ++i) {
            V v = this.vertexFactory.create();
            this.mGraph.addVertex(v);
            this.vertex_index.add(v);
            this.index_vertex.put((Integer)v, i);
            seedVertices.add(v);
        }
        this.mElapsedTimeSteps = 0;
    }

    private E createRandomEdge(Collection<V> preexistingNodes, V newVertex, Map<E, Pair<V>> added_pairs) {
        Pair<V> endpoints;
        V attach_point;
        boolean created_edge = false;
        do {
            double degree;
            double attach_prob;
            attach_point = this.vertex_index.get(this.mRandom.nextInt(this.vertex_index.size()));
            endpoints = new Pair<V>(newVertex, attach_point);
            if (!this.parallel && added_pairs.containsValue(endpoints) || !((attach_prob = ((degree = this.directed ? (double)this.mGraph.inDegree(attach_point) : (double)this.mGraph.degree(attach_point)) + 1.0) / (double)(this.mGraph.getEdgeCount() + this.mGraph.getVertexCount() - 1)) >= this.mRandom.nextDouble())) continue;
            created_edge = true;
        } while (!created_edge);
        E to_add = this.edgeFactory.create();
        added_pairs.put(to_add, endpoints);
        if (!this.directed) {
            added_pairs.put(to_add, new Pair<V>(attach_point, newVertex));
        }
        return to_add;
    }

    @Override
    public void evolveGraph(int numTimeSteps) {
        for (int i = 0; i < numTimeSteps; ++i) {
            this.evolveGraph();
            ++this.mElapsedTimeSteps;
        }
    }

    private void evolveGraph() {
        Collection preexistingNodes = this.mGraph.getVertices();
        V newVertex = this.vertexFactory.create();
        this.mGraph.addVertex(newVertex);
        LinkedList edges = new LinkedList();
        HashMap added_pairs = new HashMap(this.mNumEdgesToAttachPerStep * 3);
        for (int i = 0; i < this.mNumEdgesToAttachPerStep; ++i) {
            edges.add(this.createRandomEdge(preexistingNodes, newVertex, added_pairs));
        }
        for (Object edge : edges) {
            this.mGraph.addEdge(edge, ((Pair)added_pairs.get(edge)).getFirst(), ((Pair)added_pairs.get(edge)).getSecond(), EdgeType.DIRECTED);
        }
        this.vertex_index.add(newVertex);
        this.index_vertex.put((Integer)newVertex, new Integer(this.vertex_index.size() - 1));
    }

    public int getIndex(V v) {
        return this.index_vertex.get(v);
    }

    @Override
    public int numIterations() {
        return this.mElapsedTimeSteps;
    }

    @Override
    public Graph<V, E> create() {
        return this.mGraph;
    }

    public void reset(Set<V> seedVertices) {
        this.initialize(seedVertices);
    }
}

