/*
 * Decompiled with CFR 0.152.
 */
package edu.tsinghua.keg.graphsummary.evaluate;

import edu.tsinghua.keg.graphsummary.evaluate.GraphSummMarker;
import edu.uci.ics.jung.visualization.RenderContext;
import java.awt.BasicStroke;
import java.awt.Stroke;
import java.util.Collection;
import org.apache.commons.collections15.Transformer;

public final class VertexStrokeHighlight<V, E>
implements Transformer<V, Stroke> {
    private Stroke heavy = new BasicStroke(4.0f);
    private Stroke medium = new BasicStroke(2.0f);
    private Stroke light = new BasicStroke(1.0f);
    private Stroke dotted = RenderContext.DOTTED;
    private GraphSummMarker<V, E> marker;

    public VertexStrokeHighlight(GraphSummMarker<V, E> marker) {
        this.marker = marker;
    }

    @Override
    public Stroke transform(V v) {
        if (this.marker.vertex_deleted.get(v).booleanValue()) {
            return this.dotted;
        }
        if (this.marker.strokePickVertex) {
            if (this.marker.vv.getPickedVertexState().isPicked(v)) {
                return this.heavy;
            }
            Collection<V> neighbors = this.marker.graph.getNeighbors(v);
            for (V w : neighbors) {
                if (!this.marker.vv.getPickedVertexState().isPicked(w)) continue;
                return this.medium;
            }
            return this.light;
        }
        return this.light;
    }
}

