/*
 * Decompiled with CFR 0.152.
 */
package edu.tsinghua.keg.graphsummary.evaluate;

import edu.tsinghua.keg.graphsummary.evaluate.GraphSummMarker;
import edu.uci.ics.jung.visualization.decorators.AbstractVertexShapeTransformer;
import java.awt.Shape;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.collections15.Transformer;

public final class VertexShapeSizeAspect<V, E>
extends AbstractVertexShapeTransformer<V>
implements Transformer<V, Shape> {
    private GraphSummMarker<V, E> marker;

    public VertexShapeSizeAspect(final GraphSummMarker<V, E> marker) {
        this.marker = marker;
        this.setSizeTransformer(new Transformer<V, Integer>(){

            @Override
            public Integer transform(V v) {
                if (marker.scaleVertex) {
                    HashSet<Integer> temp = new HashSet<Integer>();
                    Collection<Integer> pcs = marker.vertex_labels.values();
                    for (Integer i : pcs) {
                        if (temp.contains(i)) continue;
                        temp.add(i);
                    }
                    int maxpc = 0;
                    int minpc = 1000000;
                    Iterator iterator = temp.iterator();
                    while (iterator.hasNext()) {
                        int pc = (Integer)iterator.next();
                        if (pc > maxpc) {
                            maxpc = pc;
                        }
                        if (pc >= minpc) continue;
                        minpc = pc;
                    }
                    if ((maxpc -= minpc) == 0) {
                        maxpc = 2;
                    }
                    int pubc = marker.vertex_labels.get(v);
                    return (pubc - minpc) * 30 / maxpc + 20;
                }
                return 20;
            }
        });
    }

    @Override
    public Shape transform(V v) {
        return this.factory.getEllipse(v);
    }
}

