/*
 * Decompiled with CFR 0.152.
 */
package edu.tsinghua.keg.graphsummary.evaluate;

import edu.tsinghua.keg.graphsummary.evaluate.GraphSummMarker;
import edu.uci.ics.jung.graph.util.Pair;
import java.awt.Color;
import java.awt.Paint;
import java.util.Collection;
import org.apache.commons.collections15.Transformer;

public final class VertexFillColor<V, E>
implements Transformer<V, Paint> {
    protected GraphSummMarker<V, E> marker;
    protected static final float pickedAlpha = 1.0f;
    protected static final float pickedDeletedAlpha = 0.4f;
    protected static final float notPickedAlpha = 0.9f;
    protected static final float notPickedDeletedAlpha = 0.2f;

    public VertexFillColor(GraphSummMarker<V, E> marker) {
        this.marker = marker;
    }

    @Override
    public Paint transform(V v) {
        if (this.marker.vv.getPickedVertexState().isPicked(v)) {
            if (this.marker.vertex_deleted.get(v).booleanValue()) {
                return new Color(0.0f, 0.0f, 1.0f, 0.4f);
            }
            return new Color(1.0f, 1.0f, 0.0f, 1.0f);
        }
        Collection edges = this.marker.graph.getInEdges(v);
        for (Object e : edges) {
            if (!this.marker.vv.getPickedEdgeState().isPicked(e)) continue;
            if (this.marker.vertex_deleted.get(v).booleanValue()) {
                return new Color(0.0f, 1.0f, 0.0f, 0.4f);
            }
            return new Color(0.0f, 1.0f, 0.0f, 1.0f);
        }
        if (this.marker.vertex_deleted.get(v).booleanValue()) {
            return new Color(0.7f, 0.7f, 0.7f, 0.2f);
        }
        Collection es = this.marker.graph.getInEdges(v);
        for (Object e : es) {
            Pair p = this.marker.graph.getEndpoints(e);
            for (Object vv : p) {
                if (vv == v || this.marker.edge_deleted.get(e).booleanValue() || !this.marker.vv.getPickedVertexState().isPicked(vv)) continue;
                return new Color(0.7f, 0.7f, 0.0f, 0.9f);
            }
        }
        return new Color(1.0f, 0.0f, 0.0f, 0.9f);
    }
}

