/*
 * Decompiled with CFR 0.152.
 */
package edu.tsinghua.keg.graphsummary.evaluate;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Pair;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;

public class GraphWriter<G extends Graph<V, E>, V extends Number, E extends Number> {
    public void save(Graph<V, E> graph, HashMap<V, Integer> labels, HashMap<V, String> names, HashMap<E, Integer> edge_weights, Writer wr, HashMap<V, Boolean> vertexDeleted, HashMap<E, Boolean> edgesDeleted) throws IOException {
        BufferedWriter writer = new BufferedWriter(wr);
        writer.write("*Vertices " + graph.getVertexCount());
        writer.newLine();
        ArrayList id = new ArrayList(graph.getVertices());
        for (Number currentVertex : graph.getVertices()) {
            int v_id = id.indexOf(currentVertex) + 1;
            writer.write("" + v_id);
            if (names.get(currentVertex) != null) {
                writer.write(" \"" + names.get(currentVertex) + "\"");
            }
            if (labels.get(currentVertex) != null) {
                writer.write(" " + labels.get(currentVertex));
            }
            if (vertexDeleted.get(currentVertex).booleanValue()) {
                writer.write(" delete");
            }
            writer.newLine();
        }
        writer.write("*Edges");
        writer.newLine();
        for (Number e : graph.getEdges()) {
            Pair<V> endpoints = graph.getEndpoints(e);
            int v1_id = id.indexOf(endpoints.getFirst()) + 1;
            int v2_id = id.indexOf(endpoints.getSecond()) + 1;
            Integer weight = edge_weights.get(e);
            writer.write(String.valueOf(v1_id) + " " + v2_id + " " + weight);
            if (edgesDeleted.get(e).booleanValue()) {
                writer.write(" delete");
            }
            writer.newLine();
        }
        writer.close();
    }
}

