/*
 * Decompiled with CFR 0.152.
 */
package edu.tsinghua.keg.graphsummary.evaluate;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedSparseGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.StringTokenizer;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.functors.OrPredicate;

public class GraphReader<G extends Graph<V, E>, V extends Number, E extends Number> {
    protected HashMap<V, Integer> vertex_labels;
    protected HashMap<V, String> vertex_names;
    protected HashMap<E, Integer> edge_weights;
    protected HashMap<V, Boolean> vertex_deleted;
    protected HashMap<E, Boolean> edge_deleted;
    private static final Predicate<String> v_pred = new StartsWithPredicate("*vertices");
    private static final Predicate<String> a_pred = new StartsWithPredicate("*arcs");
    private static final Predicate<String> e_pred = new StartsWithPredicate("*edges");
    private static final Predicate<String> t_pred = new StartsWithPredicate("*");
    private static final Predicate<String> c_pred = OrPredicate.getInstance(a_pred, e_pred);
    protected static final Predicate<String> l_pred = ListTagPred.getInstance();

    public Graph<V, E> load(Reader reader) throws IOException {
        this.vertex_labels = new HashMap();
        this.vertex_names = new HashMap();
        this.edge_weights = new HashMap();
        this.vertex_deleted = new HashMap();
        this.edge_deleted = new HashMap();
        Factory graphFactory = new Factory<Graph<V, E>>(){

            @Override
            public Graph<V, E> create() {
                return new UndirectedSparseGraph();
            }
        };
        Graph g = (Graph)graphFactory.create();
        BufferedReader br = new BufferedReader(reader);
        String curLine = this.skip(br, v_pred);
        if (curLine == null) {
            return g;
        }
        StringTokenizer st = new StringTokenizer(curLine);
        st.nextToken();
        int num_vertices = Integer.parseInt(st.nextToken());
        curLine = null;
        while (br.ready()) {
            curLine = br.readLine();
            if (curLine == null || t_pred.evaluate(curLine)) break;
            if (curLine == "") continue;
            try {
                V v = this.readVertex(curLine, num_vertices);
                g.addVertex(v);
            }
            catch (IllegalArgumentException iae) {
                br.close();
                reader.close();
                throw iae;
            }
        }
        this.readArcsOrEdges(curLine, br, g);
        br.close();
        return g;
    }

    private V readVertex(String curLine, int num_vertices) {
        int v_id;
        String index = null;
        String label = null;
        String name = null;
        boolean deleted = false;
        if (curLine.indexOf(34) != -1) {
            String[] initial_split = curLine.trim().split("\"");
            if (initial_split.length < 2 || initial_split.length > 3) {
                throw new IllegalArgumentException("Unbalanced (or too many) quote marks in " + curLine);
            }
            index = initial_split[0].trim();
            name = initial_split[1].trim();
            if (initial_split.length == 3) {
                String[] tks = initial_split[2].trim().split(" ");
                if (tks.length >= 2 && tks[1].equals("delete")) {
                    deleted = true;
                }
                label = tks[0];
            }
        }
        if ((v_id = Integer.parseInt(index) - 1) >= num_vertices || v_id < 0) {
            throw new IllegalArgumentException("Vertex number " + v_id + "is not in the range [1," + num_vertices + "]");
        }
        Integer v = new Integer(v_id);
        if (label != null && label.length() > 0 && this.vertex_labels != null) {
            this.vertex_labels.put(v, Integer.valueOf(label));
        } else {
            this.vertex_labels.put(v, 0);
        }
        if (name != null && name.length() > 0 && this.vertex_names != null) {
            this.vertex_names.put((String)((Object)v), name);
        } else {
            this.vertex_names.put((String)((Object)v), "Unknown");
        }
        this.vertex_deleted.put((Boolean)((Object)v), deleted);
        return (V)v;
    }

    private void readArcsOrEdges(String curLine, BufferedReader br, Graph<V, E> g) throws IOException {
        String nextLine = curLine;
        if (!c_pred.evaluate(curLine)) {
            nextLine = this.skip(br, c_pred);
        }
        EdgeType directedness = EdgeType.UNDIRECTED;
        if (!e_pred.evaluate(nextLine)) {
            throw new IllegalArgumentException("Supplied undirected-only graph cannot be populated with directed edges");
        }
        int edgecount = 0;
        while (br.ready()) {
            nextLine = br.readLine();
            if (nextLine == null || t_pred.evaluate(nextLine)) break;
            if (curLine == "") continue;
            StringTokenizer st = new StringTokenizer(nextLine.trim());
            int vid1 = Integer.parseInt(st.nextToken()) - 1;
            Integer v1 = new Integer(vid1);
            E e = this.createAddEdge(st, v1, directedness, g, edgecount);
            ++edgecount;
            if (this.edge_weights != null && st.hasMoreTokens()) {
                this.edge_weights.put(e, new Integer(st.nextToken()));
            }
            boolean deleted = false;
            if (st.hasMoreTokens() && "delete".equals(st.nextToken())) {
                deleted = true;
            }
            this.edge_deleted.put(e, deleted);
        }
    }

    protected E createAddEdge(StringTokenizer st, V v1, EdgeType directed, Graph<V, E> g, int edgecount) {
        int vid2 = Integer.parseInt(st.nextToken()) - 1;
        Integer v2 = new Integer(vid2);
        Integer e = new Integer(edgecount);
        g.addEdge(e, (Integer)v1, v2, directed);
        return (E)e;
    }

    protected String skip(BufferedReader br, Predicate<String> p) throws IOException {
        while (br.ready()) {
            String curLine = br.readLine();
            if (curLine == null) break;
            if (!p.evaluate(curLine = curLine.trim())) continue;
            return curLine;
        }
        return null;
    }

    public HashMap<V, Integer> getVertexLabels() {
        return this.vertex_labels;
    }

    public HashMap<E, Integer> getEdgeWeights() {
        return this.edge_weights;
    }

    public HashMap<V, String> getVertex_Names() {
        return this.vertex_names;
    }

    public HashMap<V, Boolean> getVertexDeleted() {
        return this.vertex_deleted;
    }

    public HashMap<E, Boolean> getEdgeDeleted() {
        return this.edge_deleted;
    }

    protected static class ListTagPred
    implements Predicate<String> {
        protected static ListTagPred instance;

        protected ListTagPred() {
        }

        public static ListTagPred getInstance() {
            if (instance == null) {
                instance = new ListTagPred();
            }
            return instance;
        }

        @Override
        public boolean evaluate(String s) {
            return s != null && s.toLowerCase().endsWith("list");
        }
    }

    protected static class StartsWithPredicate
    implements Predicate<String> {
        private String tag;

        public StartsWithPredicate(String s) {
            this.tag = s;
        }

        @Override
        public boolean evaluate(String str) {
            return str != null && str.toLowerCase().startsWith(this.tag);
        }
    }
}

