/*
 * Decompiled with CFR 0.152.
 */
package edu.tsinghua.keg.graphsummary.evaluate;

import edu.tsinghua.keg.graphsummary.evaluate.GraphSummMarker;
import edu.uci.ics.jung.visualization.RenderContext;
import java.awt.BasicStroke;
import java.awt.Stroke;
import java.util.Collection;
import java.util.HashSet;
import org.apache.commons.collections15.Transformer;

public final class EdgeStyleStrokeTransf<V, E>
implements Transformer<E, Stroke> {
    private static final Stroke basic = new BasicStroke(1.0f);
    private static final Stroke mid2 = new BasicStroke(2.0f);
    private static final Stroke mid3 = new BasicStroke(3.0f);
    private static final Stroke mid4 = new BasicStroke(4.0f);
    private static final Stroke big = new BasicStroke(5.0f);
    private static final Stroke dotted = RenderContext.DOTTED;
    private GraphSummMarker<V, E> marker;

    public EdgeStyleStrokeTransf(GraphSummMarker<V, E> marker) {
        this.marker = marker;
    }

    @Override
    public Stroke transform(E e) {
        if (this.marker.useDiffLineStyle) {
            if (this.marker.edge_deleted.get(e).booleanValue()) {
                return dotted;
            }
            HashSet<Integer> temp = new HashSet<Integer>();
            Collection<Integer> ws = this.marker.edge_weights.values();
            for (Integer w : ws) {
                if (temp.contains(w)) continue;
                temp.add(w);
            }
            float max = 0.0f;
            float min = 1000000.0f;
            float avg = 0.0f;
            for (Integer w : temp) {
                avg += (float)w.intValue();
                if ((float)w.intValue() > max) {
                    max = w.intValue();
                }
                if (!((float)w.intValue() < min)) continue;
                min = w.intValue();
            }
            if (temp.size() > 0) {
                avg /= (float)temp.size();
            }
            if (avg == 0.0f) {
                return basic;
            }
            avg -= min;
            max -= min;
            float weight = this.marker.edge_weights.get(e).intValue();
            if ((weight -= min) <= avg / 3.0f) {
                return basic;
            }
            if (weight < avg * 2.0f / 3.0f) {
                return mid2;
            }
            if (weight < avg + (max - avg) / 3.0f) {
                return mid3;
            }
            if (weight < avg + (max - avg) * 2.0f / 3.0f) {
                return mid4;
            }
            return big;
        }
        if (this.marker.edge_deleted.get(e).booleanValue()) {
            return dotted;
        }
        return basic;
    }
}

