/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung3d.visualization;

import com.sun.j3d.utils.picking.PickResult;
import com.sun.j3d.utils.picking.behaviors.PickTranslateBehavior;
import edu.uci.ics.jung.visualization.picking.PickedState;
import edu.uci.ics.jung.visualization.util.ChangeEventSupport;
import edu.uci.ics.jung.visualization.util.DefaultChangeEventSupport;
import edu.uci.ics.jung3d.visualization.VertexGroup;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.TransformGroup;
import javax.swing.event.ChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PickVertexBehavior<V, E>
extends PickTranslateBehavior
implements ChangeEventSupport {
    Bounds bounds;
    BranchGroup root;
    ChangeEventSupport support = new DefaultChangeEventSupport(this);
    PickedState<V> pickedState;

    public PickVertexBehavior(BranchGroup root, Canvas3D canvas, Bounds bounds, PickedState<V> pickedState) {
        super(root, canvas, bounds);
        this.setSchedulingBounds(bounds);
        this.bounds = bounds;
        this.root = root;
        this.pickedState = pickedState;
        this.pickCanvas.setMode(256);
    }

    public void updateScene(int xpos, int ypos) {
        if (this.mevent.getButton() == 1) {
            int buttonOne = 16;
            int shiftButtonOne = 17;
            int modifiers = this.mevent.getModifiers();
            if (modifiers == buttonOne) {
                this.pickedState.clear();
                this.doPick(xpos, ypos);
            } else if (modifiers == shiftButtonOne) {
                this.doPick(xpos, ypos);
            }
        }
    }

    private void doPick(int xpos, int ypos) {
        TransformGroup tg;
        this.pickCanvas.setShapeLocation(xpos, ypos);
        PickResult result = this.pickCanvas.pickClosest();
        if (result != null && (tg = (TransformGroup)result.getNode(32)) instanceof VertexGroup) {
            System.err.println("picked " + tg);
            this.pickedState.pick(((VertexGroup)tg).vertex, true);
            this.fireStateChanged();
        }
    }

    @Override
    public void addChangeListener(ChangeListener l) {
        this.support.addChangeListener(l);
    }

    @Override
    public void fireStateChanged() {
        this.support.fireStateChanged();
    }

    @Override
    public ChangeListener[] getChangeListeners() {
        return this.support.getChangeListeners();
    }

    @Override
    public void removeChangeListener(ChangeListener l) {
        this.support.removeChangeListener(l);
    }
}

