/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.util;

import java.io.PrintStream;

public final class NumericalPrecision {
    private static double defaultNumericalPrecision = 0.0;
    private static double smallNumber = 0.0;
    private static int radix = 0;
    private static double machinePrecision = 0.0;
    private static double negativeMachinePrecision = 0.0;
    private static double smallestNumber = 0.0;
    private static double largestNumber = 0.0;
    private static double largestExponentialArgument = 0.0;
    private static final double[] scales = new double[]{1.25, 2.0, 2.5, 4.0, 5.0, 7.5, 8.0, 10.0};
    private static final double[] semiIntegerScales = new double[]{2.0, 2.5, 4.0, 5.0, 7.5, 8.0, 10.0};
    private static final double[] integerScales = new double[]{2.0, 4.0, 5.0, 8.0, 10.0};

    private static void computeLargestNumber() {
        double floatingRadix = NumericalPrecision.getRadix();
        double fullMantissaNumber = 1.0 - floatingRadix * NumericalPrecision.getNegativeMachinePrecision();
        while (!Double.isInfinite(fullMantissaNumber)) {
            largestNumber = fullMantissaNumber;
            fullMantissaNumber *= floatingRadix;
        }
    }

    private static void computeMachinePrecision() {
        double floatingRadix = NumericalPrecision.getRadix();
        double inverseRadix = 1.0 / floatingRadix;
        machinePrecision = 1.0;
        double tmp = 1.0 + machinePrecision;
        while (tmp - 1.0 != 0.0) {
            tmp = 1.0 + (machinePrecision *= inverseRadix);
        }
    }

    private static void computeNegativeMachinePrecision() {
        double floatingRadix = NumericalPrecision.getRadix();
        double inverseRadix = 1.0 / floatingRadix;
        negativeMachinePrecision = 1.0;
        double tmp = 1.0 - negativeMachinePrecision;
        while (tmp - 1.0 != 0.0) {
            tmp = 1.0 - (negativeMachinePrecision *= inverseRadix);
        }
    }

    private static void computeRadix() {
        double tmp1;
        double tmp2;
        double a = 1.0;
        while ((tmp2 = (tmp1 = (a += a) + 1.0) - a) - 1.0 != 0.0) {
        }
        double b = 1.0;
        while (radix == 0) {
            b += b;
            tmp1 = a + b;
            radix = (int)(tmp1 - a);
        }
    }

    private static void computeSmallestNumber() {
        double floatingRadix = NumericalPrecision.getRadix();
        double inverseRadix = 1.0 / floatingRadix;
        for (double fullMantissaNumber = 1.0 - floatingRadix * NumericalPrecision.getNegativeMachinePrecision(); fullMantissaNumber != 0.0; fullMantissaNumber *= inverseRadix) {
            smallestNumber = fullMantissaNumber;
        }
    }

    public static double defaultNumericalPrecision() {
        if (defaultNumericalPrecision == 0.0) {
            defaultNumericalPrecision = Math.sqrt(NumericalPrecision.getMachinePrecision());
        }
        return defaultNumericalPrecision;
    }

    public static boolean equal(double a, double b) {
        return NumericalPrecision.equal(a, b, NumericalPrecision.defaultNumericalPrecision());
    }

    public static boolean equal(double a, double b, double precision) {
        double norm = Math.max(Math.abs(a), Math.abs(b));
        return norm < precision || Math.abs(a - b) < precision * norm;
    }

    public static double getLargestExponentialArgument() {
        if (largestExponentialArgument == 0.0) {
            largestExponentialArgument = Math.log(NumericalPrecision.getLargestNumber());
        }
        return largestExponentialArgument;
    }

    public static double getLargestNumber() {
        if (largestNumber == 0.0) {
            NumericalPrecision.computeLargestNumber();
        }
        return largestNumber;
    }

    public static double getMachinePrecision() {
        if (machinePrecision == 0.0) {
            NumericalPrecision.computeMachinePrecision();
        }
        return machinePrecision;
    }

    public static double getNegativeMachinePrecision() {
        if (negativeMachinePrecision == 0.0) {
            NumericalPrecision.computeNegativeMachinePrecision();
        }
        return negativeMachinePrecision;
    }

    public static int getRadix() {
        if (radix == 0) {
            NumericalPrecision.computeRadix();
        }
        return radix;
    }

    public static double getSmallestNumber() {
        if (smallestNumber == 0.0) {
            NumericalPrecision.computeSmallestNumber();
        }
        return smallestNumber;
    }

    public static void printParameters(PrintStream printStream) {
        printStream.println("Floating-point machine parameters");
        printStream.println("---------------------------------");
        printStream.println(" ");
        printStream.println("radix = " + NumericalPrecision.getRadix());
        printStream.println("Machine precision = " + NumericalPrecision.getMachinePrecision());
        printStream.println("Negative machine precision = " + NumericalPrecision.getNegativeMachinePrecision());
        printStream.println("Smallest number = " + NumericalPrecision.getSmallestNumber());
        printStream.println("Largest number = " + NumericalPrecision.getLargestNumber());
    }

    public static void reset() {
        defaultNumericalPrecision = 0.0;
        smallNumber = 0.0;
        radix = 0;
        machinePrecision = 0.0;
        negativeMachinePrecision = 0.0;
        smallestNumber = 0.0;
        largestNumber = 0.0;
    }

    public static double roundTo(double value, double scale) {
        return (double)Math.round(value / scale) * scale;
    }

    public static double roundToScale(double value, boolean integerValued) {
        int orderOfMagnitude = (int)Math.floor(Math.log(value) / Math.log(10.0));
        double[] scaleValues = integerValued ? ((orderOfMagnitude = Math.max(1, orderOfMagnitude)) == 1 ? integerScales : (orderOfMagnitude == 2 ? semiIntegerScales : scales)) : scales;
        double exponent = Math.pow(10.0, orderOfMagnitude);
        double rValue = value / exponent;
        for (int n = 0; n < scaleValues.length; ++n) {
            if (!(rValue <= scaleValues[n])) continue;
            return scaleValues[n] * exponent;
        }
        return exponent;
    }

    public static double smallNumber() {
        if (smallNumber == 0.0) {
            smallNumber = Math.sqrt(NumericalPrecision.getSmallestNumber());
        }
        return smallNumber;
    }
}

