/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.scoring;

import edu.uci.ics.jung.algorithms.scoring.AbstractIterativeScorerWithPriors;
import edu.uci.ics.jung.algorithms.scoring.HITS;
import edu.uci.ics.jung.graph.Graph;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.functors.ConstantTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HITSWithPriors<V, E>
extends AbstractIterativeScorerWithPriors<V, E, HITS.Scores> {
    protected HITS.Scores disappearing_potential = new HITS.Scores(0.0, 0.0);

    public HITSWithPriors(Graph<V, E> g, Transformer<E, ? extends Number> edge_weights, Transformer<V, HITS.Scores> vertex_priors, double alpha) {
        super(g, edge_weights, vertex_priors, alpha);
    }

    public HITSWithPriors(Graph<V, E> g, Transformer<V, HITS.Scores> vertex_priors, double alpha) {
        super(g, new ConstantTransformer<Double>(1.0), vertex_priors, alpha);
    }

    @Override
    protected double update(V v) {
        this.collectDisappearingPotential(v);
        double auth = 0.0;
        for (Object e : this.graph.getInEdges(v)) {
            V w = this.graph.getOpposite(v, e);
            auth += ((HITS.Scores)this.getCurrentValue(w)).hub * this.getEdgeWeight(w, e).doubleValue();
        }
        double hub = 0.0;
        for (Object e : this.graph.getOutEdges(v)) {
            V x = this.graph.getOpposite(v, e);
            hub += ((HITS.Scores)this.getCurrentValue(x)).authority * this.getEdgeWeight(x, e).doubleValue();
        }
        auth = auth * (1.0 - this.alpha) + ((HITS.Scores)this.getVertexPrior(v)).authority * this.alpha;
        hub = hub * (1.0 - this.alpha) + ((HITS.Scores)this.getVertexPrior(v)).hub * this.alpha;
        this.setOutputValue(v, new HITS.Scores(hub, auth));
        return Math.max(Math.abs(((HITS.Scores)this.getCurrentValue(v)).hub - hub), Math.abs(((HITS.Scores)this.getCurrentValue(v)).authority - auth));
    }

    @Override
    protected void afterStep() {
        if (this.disappearing_potential.hub > 0.0 || this.disappearing_potential.authority > 0.0) {
            for (Object v : this.graph.getVertices()) {
                double new_hub = ((HITS.Scores)this.getOutputValue(v)).hub + (1.0 - this.alpha) * (this.disappearing_potential.hub * ((HITS.Scores)this.getVertexPrior(v)).hub);
                double new_auth = ((HITS.Scores)this.getOutputValue(v)).authority + (1.0 - this.alpha) * (this.disappearing_potential.authority * ((HITS.Scores)this.getVertexPrior(v)).authority);
                this.setOutputValue(v, new HITS.Scores(new_hub, new_auth));
            }
            this.disappearing_potential.hub = 0.0;
            this.disappearing_potential.authority = 0.0;
        }
        this.normalizeScores();
        super.afterStep();
    }

    protected void normalizeScores() {
        double hub_ssum = 0.0;
        double auth_ssum = 0.0;
        for (Object v : this.graph.getVertices()) {
            double hub_val = ((HITS.Scores)this.getOutputValue(v)).hub;
            double auth_val = ((HITS.Scores)this.getOutputValue(v)).authority;
            hub_ssum += hub_val * hub_val;
            auth_ssum += auth_val * auth_val;
        }
        hub_ssum = Math.sqrt(hub_ssum);
        auth_ssum = Math.sqrt(auth_ssum);
        for (Object v : this.graph.getVertices()) {
            HITS.Scores values = (HITS.Scores)this.getOutputValue(v);
            this.setOutputValue(v, new HITS.Scores(values.hub / hub_ssum, values.authority / auth_ssum));
        }
    }

    @Override
    protected void collectDisappearingPotential(V v) {
        if (this.graph.outDegree(v) == 0) {
            if (this.isDisconnectedGraphOK()) {
                this.disappearing_potential.hub += ((HITS.Scores)this.getCurrentValue(v)).authority;
            } else {
                throw new IllegalArgumentException("Outdegree of " + v + " must be > 0");
            }
        }
        if (this.graph.inDegree(v) == 0) {
            if (this.isDisconnectedGraphOK()) {
                this.disappearing_potential.authority += ((HITS.Scores)this.getCurrentValue(v)).hub;
            } else {
                throw new IllegalArgumentException("Indegree of " + v + " must be > 0");
            }
        }
    }
}

