/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.importance;

import edu.uci.ics.jung.algorithms.util.ConstantMap;
import edu.uci.ics.jung.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VoltageRanker<V, E> {
    protected Map<E, Number> edge_weights;
    protected Map<V, Number> voltages;
    protected int max_iterations;
    protected double convergence_threshold;

    public VoltageRanker(Map<E, Number> edge_weights, Map<V, Number> voltages, int num_iterations, double convergence_threshold) {
        assert (num_iterations > 0) : "num_iterations must be > 0";
        assert (convergence_threshold >= 0.0) : "convergence_threshold must be >= 0";
        this.edge_weights = edge_weights;
        this.voltages = voltages;
        this.max_iterations = num_iterations;
        this.convergence_threshold = convergence_threshold;
    }

    public VoltageRanker(Map<V, Number> voltages, int num_iterations, double threshold) {
        this(new ConstantMap(new Integer(1)), voltages, num_iterations, threshold);
    }

    public void calculateVoltages(Graph<V, E> g, Set<V> sources, Set<V> sinks) {
        if (sources == null || sources.isEmpty() || sinks == null || sinks.isEmpty()) {
            throw new IllegalArgumentException("at least one source and one sink must exist");
        }
        if (sources.size() + sinks.size() > g.getVertexCount()) {
            throw new IllegalArgumentException("either sources and sinks overlap or sources and sinks contain vertices not in g");
        }
        HashMap<V, Double> unit_sources = new HashMap<V, Double>();
        for (V v : sources) {
            unit_sources.put(v, new Double(1.0));
        }
        this.calculateVoltages(g, (V)unit_sources, (V)sinks);
    }

    public void calculateVoltages(Graph<V, E> g, Map<V, Number> source_voltages, Set<V> sinks) {
        if (source_voltages == null || source_voltages.isEmpty() || sinks == null || sinks.isEmpty()) {
            throw new IllegalArgumentException("at least one source and one sink must exist");
        }
        if (source_voltages.size() + sinks.size() > g.getVertexCount()) {
            throw new IllegalArgumentException("either sources and sinks overlap or sources and sinks contain vertices not in g");
        }
        Set<V> sources = source_voltages.keySet();
        Collection vertices = g.getVertices();
        ArrayList list = new ArrayList(vertices);
        double[] volt_array = new double[vertices.size()];
        for (int i = 0; i < volt_array.length; ++i) {
            Object v = list.get(i);
            if (sources.contains(v)) {
                Number voltage = source_voltages.get(v);
                volt_array[i] = voltage.doubleValue();
                this.voltages.put((Number)v, voltage);
                continue;
            }
            volt_array[i] = 0.0;
            this.voltages.put((Number)v, new Double(0.0));
        }
        int iteration = 0;
        double max_change = Double.POSITIVE_INFINITY;
        while (iteration++ < this.max_iterations && max_change > this.convergence_threshold) {
            max_change = 0.0;
            for (Object v : vertices) {
                if (sources.contains(v) || sinks.contains(v)) continue;
                Collection<E> edges = g.getInEdges(v);
                double voltage_sum = 0.0;
                double weight_sum = 0.0;
                for (E e : edges) {
                    V w = g.getOpposite(v, e);
                    double weight = this.edge_weights.get(e).doubleValue();
                    voltage_sum += volt_array[list.indexOf(w)] * weight;
                    weight_sum += weight;
                }
                double new_voltage = voltage_sum == 0.0 && weight_sum == 0.0 ? 0.0 : voltage_sum / weight_sum;
                max_change = Math.max(max_change, Math.abs(this.voltages.get(v).doubleValue() - new_voltage));
                this.voltages.put((Number)v, new Double(new_voltage));
            }
            for (int j = 0; j < volt_array.length; ++j) {
                volt_array[j] = this.voltages.get(list.get(j)).doubleValue();
            }
        }
    }

    public void calculateVoltages(Graph<V, E> g, V source, V target) {
        Set<V> sources = Collections.singleton(source);
        Set<V> sinks = Collections.singleton(target);
        this.calculateVoltages(g, (V)sources, (V)sinks);
    }
}

