/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.importance;

import edu.uci.ics.jung.algorithms.importance.AbstractRanker;
import edu.uci.ics.jung.graph.Graph;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HITS<V, E>
extends AbstractRanker<V, E> {
    protected static final String AUTHORITY_KEY = "jung.algorithms.importance.AUTHORITY";
    protected static final String HUB_KEY = "jung.algorithms.importance.HUB";
    private Object mKeyToUseForRanking = "jung.algorithms.importance.AUTHORITY";
    private Map<V, Number> mPreviousAuthorityScores;
    private Map<V, Number> mPreviousHubScores;

    public HITS(Graph<V, E> graph, boolean useAuthorityForRanking) {
        if (!useAuthorityForRanking) {
            this.mKeyToUseForRanking = HUB_KEY;
        }
        this.initialize(graph);
    }

    public HITS(Graph<V, E> graph) {
        this.initialize(graph);
    }

    protected void initialize(Graph<V, E> g) {
        super.initialize(g, true, false);
        this.mPreviousAuthorityScores = new HashMap<V, Number>();
        this.mPreviousHubScores = new HashMap<V, Number>();
        for (Object currentVertex : g.getVertices()) {
            this.setVertexRankScore(currentVertex, 1.0, AUTHORITY_KEY);
            this.setVertexRankScore(currentVertex, 1.0, HUB_KEY);
            this.mPreviousAuthorityScores.put((Number)currentVertex, 0);
            this.mPreviousHubScores.put((Number)currentVertex, 0);
        }
    }

    @Override
    protected void finalizeIterations() {
        super.finalizeIterations();
        for (Object v : this.getVertices()) {
            if (this.mKeyToUseForRanking.equals(AUTHORITY_KEY)) {
                super.removeVertexRankScore(v, HUB_KEY);
                continue;
            }
            super.removeVertexRankScore(v, AUTHORITY_KEY);
        }
    }

    @Override
    public Object getRankScoreKey() {
        return this.mKeyToUseForRanking;
    }

    @Override
    public double getVertexRankScore(V v) {
        return this.getVertexRankScore(v, this.mKeyToUseForRanking);
    }

    protected double getPreviousAuthorityScore(V v) {
        return this.mPreviousAuthorityScores.get(v).doubleValue();
    }

    protected double getPreviousHubScore(V v) {
        return this.mPreviousHubScores.get(v).doubleValue();
    }

    @Override
    public void step() {
        this.updatePreviousScores();
        this.updateAuthorityRankings();
        this.updateHubRankings();
        double hubMSE = 0.0;
        double authorityMSE = 0.0;
        int numVertices = this.getVertexCount();
        for (Object v : this.getVertices()) {
            double currentAuthorityScore = this.getVertexRankScore(v, AUTHORITY_KEY);
            double currentHubScore = this.getVertexRankScore(v, HUB_KEY);
            double previousAuthorityScore = this.getPreviousAuthorityScore(v);
            double previousHubScore = this.getPreviousHubScore(v);
            hubMSE += Math.pow(currentHubScore - previousHubScore, 2.0);
            authorityMSE += Math.pow(currentAuthorityScore - previousAuthorityScore, 2.0);
        }
        hubMSE = Math.pow(hubMSE / (double)numVertices, 0.5);
        authorityMSE = Math.pow(authorityMSE / (double)numVertices, 0.5);
        this.setPrecision(hubMSE + authorityMSE);
    }

    public void setUseAuthorityForRanking(boolean useAuthorityForRanking) {
        this.mKeyToUseForRanking = useAuthorityForRanking ? AUTHORITY_KEY : HUB_KEY;
    }

    private double computeSum(Collection<V> neighbors, Object key) {
        double sum = 0.0;
        for (V v : neighbors) {
            sum += this.getVertexRankScore(v, key);
        }
        return sum;
    }

    private void normalizeRankings(double normConstant, Object key) {
        for (Object v : this.getVertices()) {
            double rankScore = this.getVertexRankScore(v, key);
            this.setVertexRankScore(v, rankScore / normConstant, key);
        }
    }

    protected void updateAuthorityRankings() {
        double total = 0.0;
        for (Object v : this.getVertices()) {
            double currentHubSum;
            double newAuthorityScore = currentHubSum = this.computeSum(this.getGraph().getPredecessors(v), HUB_KEY);
            total += newAuthorityScore * newAuthorityScore;
            this.setVertexRankScore(v, newAuthorityScore, AUTHORITY_KEY);
        }
        this.normalizeRankings(Math.sqrt(total), AUTHORITY_KEY);
    }

    protected void updateHubRankings() {
        double total = 0.0;
        for (Object v : this.getVertices()) {
            double currentAuthoritySum;
            double newHubScore = currentAuthoritySum = this.computeSum(this.getGraph().getSuccessors(v), AUTHORITY_KEY);
            total += newHubScore * newHubScore;
            this.setVertexRankScore(v, newHubScore, HUB_KEY);
        }
        this.normalizeRankings(Math.sqrt(total), HUB_KEY);
    }

    protected void updatePreviousScores() {
        for (Object v : this.getVertices()) {
            double currentAuthorityScore = this.getVertexRankScore(v, AUTHORITY_KEY);
            this.mPreviousAuthorityScores.put((Number)v, currentAuthorityScore);
            double currentHubScore = this.getVertexRankScore(v, HUB_KEY);
            this.mPreviousHubScores.put((Number)v, currentHubScore);
        }
    }
}

