/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.filters;

import edu.uci.ics.jung.algorithms.filters.Filter;
import edu.uci.ics.jung.graph.Graph;
import org.apache.commons.collections15.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EdgePredicateFilter<V, E>
implements Filter<V, E> {
    protected Predicate<E> edge_pred;

    public EdgePredicateFilter(Predicate<E> edge_pred) {
        this.edge_pred = edge_pred;
    }

    @Override
    public Graph<V, E> transform(Graph<V, E> g) {
        Graph filtered;
        try {
            filtered = (Graph)g.getClass().newInstance();
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to create copy of existing graph", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to create copy of existing graph", e);
        }
        for (Object v : g.getVertices()) {
            filtered.addVertex(v);
        }
        for (Object e : g.getEdges()) {
            if (!this.edge_pred.evaluate(e)) continue;
            g.addEdge(e, g.getIncidentVertices(e));
        }
        return filtered;
    }
}

