/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.cluster;

import cern.jet.random.engine.DRand;
import cern.jet.random.engine.RandomEngine;
import edu.uci.ics.jung.algorithms.scoring.VoltageScorer;
import edu.uci.ics.jung.algorithms.util.DiscreteDistribution;
import edu.uci.ics.jung.algorithms.util.KMeansClusterer;
import edu.uci.ics.jung.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VoltageClusterer<V, E> {
    protected int num_candidates;
    protected KMeansClusterer<V> kmc;
    protected RandomEngine rand;
    protected Graph<V, E> g;

    public VoltageClusterer(Graph<V, E> g, int num_candidates) {
        if (num_candidates < 1) {
            throw new IllegalArgumentException("must generate >=1 candidates");
        }
        this.num_candidates = num_candidates;
        this.kmc = new KMeansClusterer();
        this.rand = new DRand();
        this.g = g;
    }

    protected void setRandomSeed(int random_seed) {
        this.rand = new DRand(random_seed);
    }

    public Collection<Set<V>> getCommunity(V v) {
        return this.cluster_internal(v, 2);
    }

    public Collection<Set<V>> cluster(int num_clusters) {
        return this.cluster_internal(null, num_clusters);
    }

    protected Collection<Set<V>> cluster_internal(V origin, int num_clusters) {
        ArrayList v_array = new ArrayList(this.g.getVertices());
        LinkedList<Set<V>> candidates = new LinkedList<Set<V>>();
        for (int j = 0; j < this.num_candidates; ++j) {
            V source = origin == null ? v_array.get((int)(this.rand.nextDouble() * (double)v_array.size())) : origin;
            Object target = null;
            while (source == (target = (Object)v_array.get((int)(this.rand.nextDouble() * (double)v_array.size())))) {
            }
            VoltageScorer<Object, E> vs = new VoltageScorer<Object, E>(this.g, source, target);
            vs.evaluate();
            HashMap voltage_ranks = new HashMap();
            for (Object v : this.g.getVertices()) {
                voltage_ranks.put(v, new double[]{(Double)vs.getVertexScore(v)});
            }
            this.addTwoCandidateClusters(candidates, voltage_ranks);
        }
        LinkedList<Set<V>> clusters = new LinkedList<Set<V>>();
        HashSet remaining = new HashSet(this.g.getVertices());
        List<V> seed_candidates = this.getSeedCandidates(candidates);
        int seed_index = 0;
        for (int j = 0; j < num_clusters - 1 && !remaining.isEmpty(); ++j) {
            V seed;
            if (seed_index == 0 && origin != null) {
                seed = origin;
            } else {
                while (!remaining.contains(seed = seed_candidates.get(seed_index++))) {
                }
            }
            Map<V, double[]> occur_counts = this.getObjectCounts(candidates, seed);
            if (occur_counts.size() < 2) break;
            try {
                Collection<Map<V, double[]>> high_low = this.kmc.cluster(occur_counts, 2);
                Iterator<Map<V, double[]>> h_iter = high_low.iterator();
                Map<V, double[]> cluster1 = h_iter.next();
                Map<V, double[]> cluster2 = h_iter.next();
                double[] centroid1 = DiscreteDistribution.mean(cluster1.values());
                double[] centroid2 = DiscreteDistribution.mean(cluster2.values());
                Set<V> new_cluster = centroid1[0] >= centroid2[0] ? cluster1.keySet() : cluster2.keySet();
                for (Set set : candidates) {
                    set.removeAll(new_cluster);
                }
                clusters.add(new_cluster);
                remaining.removeAll(new_cluster);
                continue;
            }
            catch (KMeansClusterer.NotEnoughClustersException nece) {
                break;
            }
        }
        if (!remaining.isEmpty()) {
            clusters.add(remaining);
        }
        return clusters;
    }

    protected void addTwoCandidateClusters(LinkedList<Set<V>> candidates, Map<V, double[]> voltage_ranks) {
        try {
            boolean b12;
            ArrayList<Map<V, double[]>> clusters = new ArrayList<Map<V, double[]>>(this.kmc.cluster(voltage_ranks, 3));
            boolean b01 = ((Map)clusters.get(0)).size() > ((Map)clusters.get(1)).size();
            boolean b02 = ((Map)clusters.get(0)).size() > ((Map)clusters.get(2)).size();
            boolean bl = b12 = ((Map)clusters.get(1)).size() > ((Map)clusters.get(2)).size();
            if (b01 && b02) {
                candidates.add(((Map)clusters.get(1)).keySet());
                candidates.add(((Map)clusters.get(2)).keySet());
            } else if (!b01 && b12) {
                candidates.add(((Map)clusters.get(0)).keySet());
                candidates.add(((Map)clusters.get(2)).keySet());
            } else if (!b02 && !b12) {
                candidates.add(((Map)clusters.get(0)).keySet());
                candidates.add(((Map)clusters.get(1)).keySet());
            }
        }
        catch (KMeansClusterer.NotEnoughClustersException notEnoughClustersException) {
            // empty catch block
        }
    }

    protected void addOneCandidateCluster(LinkedList<Set<V>> candidates, Map<V, double[]> voltage_ranks) {
        try {
            ArrayList<Map<V, double[]>> clusters = new ArrayList<Map<V, double[]>>(this.kmc.cluster(voltage_ranks, 2));
            if (((Map)clusters.get(0)).size() < ((Map)clusters.get(1)).size()) {
                candidates.add(((Map)clusters.get(0)).keySet());
            } else {
                candidates.add(((Map)clusters.get(1)).keySet());
            }
        }
        catch (KMeansClusterer.NotEnoughClustersException notEnoughClustersException) {
            // empty catch block
        }
    }

    protected List<V> getSeedCandidates(Collection<Set<V>> candidates) {
        Map<Object, double[]> occur_counts = this.getObjectCounts(candidates, null);
        ArrayList<Object> occurrences = new ArrayList<Object>(occur_counts.keySet());
        Collections.sort(occurrences, new MapValueArrayComparator(occur_counts));
        System.out.println("occurrences: ");
        for (int i = 0; i < occurrences.size(); ++i) {
            System.out.println(occur_counts.get(occurrences.get(i))[0]);
        }
        return occurrences;
    }

    protected Map<V, double[]> getObjectCounts(Collection<Set<V>> candidates, V seed) {
        HashMap occur_counts = new HashMap();
        for (Object v : this.g.getVertices()) {
            occur_counts.put(v, new double[]{0.0});
        }
        for (Set set : candidates) {
            if (seed == null) {
                System.out.println(set.size());
            }
            if (seed != null && !set.contains(seed)) continue;
            for (Object element : set) {
                double[] count = (double[])occur_counts.get(element);
                count[0] = count[0] + 1.0;
            }
        }
        if (seed == null) {
            System.out.println("occur_counts size: " + occur_counts.size());
            for (Object object : occur_counts.keySet()) {
                System.out.println(((double[])occur_counts.get(object))[0]);
            }
        }
        return occur_counts;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MapValueArrayComparator
    implements Comparator<V> {
        private Map<V, double[]> map;

        public MapValueArrayComparator(Map<V, double[]> map) {
            this.map = map;
        }

        @Override
        public int compare(V o1, V o2) {
            double[] count1;
            double[] count0 = this.map.get(o1);
            if (count0[0] < (count1 = this.map.get(o2))[0]) {
                return 1;
            }
            if (count0[0] > count1[0]) {
                return -1;
            }
            return 0;
        }
    }
}

