/*
 * Decompiled with CFR 0.152.
 */
package edu.tsinghua.keg.graphsummary.evaluate;

import edu.tsinghua.keg.graphsummary.evaluate.GraphSummMarker;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Context;
import org.apache.commons.collections15.Predicate;

public final class VertexDisplayPredicate<V, E>
implements Predicate<Context<Graph<V, E>, V>> {
    private GraphSummMarker<V, E> marker;

    public VertexDisplayPredicate(GraphSummMarker<V, E> marker) {
        this.marker = marker;
    }

    @Override
    public boolean evaluate(Context<Graph<V, E>, V> context) {
        Object v = context.element;
        if (this.marker.filterDeleted) {
            if (this.marker.vertex_deleted.get(v).booleanValue()) {
                return false;
            }
            int pubc = this.marker.vertex_labels.get(v);
            if (pubc < this.marker.filterSmallVertex) {
                return false;
            }
            if (this.marker.graph.degree(v) < this.marker.filterSmallVertexDegree) {
                return false;
            }
        } else {
            int pubc = this.marker.vertex_labels.get(v);
            if (pubc < this.marker.filterSmallVertex) {
                return false;
            }
            if (this.marker.graph.degree(v) < this.marker.filterSmallVertexDegree) {
                return false;
            }
        }
        return true;
    }
}

