/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.transform;

import edu.uci.ics.jung.visualization.transform.MutableTransformer;
import edu.uci.ics.jung.visualization.transform.MutableTransformerDecorator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Shape;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public abstract class LensTransformer
extends MutableTransformerDecorator
implements MutableTransformer {
    protected Ellipse2D ellipse = new Ellipse2D.Float();
    protected float magnification = 0.7f;

    public LensTransformer(Component component, MutableTransformer delegate) {
        super(delegate);
        this.setComponent(component);
        component.addComponentListener(new ComponentListenerImpl());
    }

    private void setComponent(Component component) {
        Dimension d = component.getSize();
        if (d.width <= 0 || d.height <= 0) {
            d = component.getPreferredSize();
        }
        float ewidth = (float)d.width / 1.5f;
        float eheight = (float)d.height / 1.5f;
        this.ellipse.setFrame((float)(d.width / 2) - ewidth / 2.0f, (float)(d.height / 2) - eheight / 2.0f, ewidth, eheight);
    }

    public float getMagnification() {
        return this.magnification;
    }

    public void setMagnification(float magnification) {
        this.magnification = magnification;
    }

    public Point2D getViewCenter() {
        return new Point2D.Double(this.ellipse.getCenterX(), this.ellipse.getCenterY());
    }

    public void setViewCenter(Point2D viewCenter) {
        double width = this.ellipse.getWidth();
        double height = this.ellipse.getHeight();
        this.ellipse.setFrame(viewCenter.getX() - width / 2.0, viewCenter.getY() - height / 2.0, width, height);
    }

    public double getViewRadius() {
        return this.ellipse.getHeight() / 2.0;
    }

    public void setViewRadius(double viewRadius) {
        double x = this.ellipse.getCenterX();
        double y = this.ellipse.getCenterY();
        double viewRatio = this.getRatio();
        this.ellipse.setFrame(x - viewRadius / viewRatio, y - viewRadius, 2.0 * viewRadius / viewRatio, 2.0 * viewRadius);
    }

    public double getRatio() {
        return this.ellipse.getHeight() / this.ellipse.getWidth();
    }

    public void setEllipse(Ellipse2D ellipse) {
        this.ellipse = ellipse;
    }

    public Ellipse2D getEllipse() {
        return this.ellipse;
    }

    public void setToIdentity() {
        this.delegate.setToIdentity();
    }

    public abstract Point2D transform(Point2D var1);

    public abstract Point2D inverseTransform(Point2D var1);

    public double getDistanceFromCenter(Point2D p) {
        double dx = this.ellipse.getCenterX() - p.getX();
        double dy = this.ellipse.getCenterY() - p.getY();
        return Math.sqrt((dx *= this.getRatio()) * dx + dy * dy);
    }

    public Shape transform(Shape shape) {
        Rectangle2D bounds = shape.getBounds2D();
        Point2D.Double center = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
        Point2D newCenter = this.transform(center);
        double dx = newCenter.getX() - ((Point2D)center).getX();
        double dy = newCenter.getY() - ((Point2D)center).getY();
        AffineTransform at = AffineTransform.getTranslateInstance(dx, dy);
        return at.createTransformedShape(shape);
    }

    public Shape inverseTransform(Shape shape) {
        Rectangle2D bounds = shape.getBounds2D();
        Point2D.Double center = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
        Point2D newCenter = this.inverseTransform(center);
        double dx = newCenter.getX() - ((Point2D)center).getX();
        double dy = newCenter.getY() - ((Point2D)center).getY();
        AffineTransform at = AffineTransform.getTranslateInstance(dx, dy);
        return at.createTransformedShape(shape);
    }

    protected class ComponentListenerImpl
    extends ComponentAdapter {
        protected ComponentListenerImpl() {
        }

        public void componentResized(ComponentEvent e) {
            LensTransformer.this.setComponent(e.getComponent());
        }
    }
}

