/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io;

import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.io.GraphFile;
import edu.uci.ics.jung.io.GraphMLFileHandler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.collections15.Factory;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphMLFile<V, E>
implements GraphFile<V, E> {
    private GraphMLFileHandler<V, E> mFileHandler;
    protected boolean directed;
    protected boolean undirected;

    public GraphMLFile(Factory<? extends Graph<V, E>> graphFactory, Factory<V> vertexFactory, Factory<E> edgeFactory) {
        this(new GraphMLFileHandler<V, E>(graphFactory, vertexFactory, edgeFactory));
    }

    public GraphMLFile(GraphMLFileHandler<V, E> handler) {
        this.mFileHandler = handler;
    }

    @Override
    public Graph<V, E> load(String filename) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new File(filename), this.mFileHandler);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading graphml file: " + filename, e);
        }
        return this.mFileHandler.getGraph();
    }

    public Graph<V, E> load(InputStream stream) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(stream, this.mFileHandler);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading graphml file", e);
        }
        return this.mFileHandler.getGraph();
    }

    public Graph<V, E> load(Reader reader) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser saxParser = factory.newSAXParser();
            InputSource is = new InputSource(reader);
            saxParser.parse(is, this.mFileHandler);
        }
        catch (Exception e) {
            throw new RuntimeException("Error loading graphml file", e);
        }
        return this.mFileHandler.getGraph();
    }

    public List<Graph<V, E>> loadGraphCollection(String dirName, FilenameFilter filter) {
        File dir = new File(dirName);
        if (!dir.isDirectory()) {
            throw new RuntimeException("Parameter dirName must be a directory");
        }
        String[] files = dir.list(filter);
        ArrayList<Graph<V, Graph<V, E>>> graphCollection = new ArrayList<Graph<V, Graph<V, E>>>();
        for (int i = 0; i < files.length; ++i) {
            String currentFile = dirName + File.separatorChar + files[i];
            GraphMLFile<V, E> graphmlFile = new GraphMLFile<V, E>(this.mFileHandler);
            Graph<V, E> graph = graphmlFile.load(currentFile);
            graphCollection.add(graph);
        }
        return graphCollection;
    }

    @Override
    public void save(Graph<V, E> g, String filename) {
        PrintStream out;
        try {
            out = new PrintStream(new FileOutputStream(filename, false));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not open file \"" + filename + "\" for writing. " + e);
        }
        this.save(g, out);
        out.close();
    }

    public void save(Graph<V, E> g, PrintStream out) {
        out.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        out.println("<graphml xmlns=\"http://graphml.graphdrawing.org/xmlns/graphml\"  xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"  ");
        out.println("xsi:schemaLocation=\"http://graphml.graphdrawing.org/xmlns/graphml\">");
        out.print("<graph edgedefault=\"");
        boolean directed = g instanceof DirectedGraph;
        boolean undirected = g instanceof UndirectedGraph;
        if (directed) {
            out.print("directed\" ");
        } else if (undirected) {
            out.print("undirected\" ");
        } else {
            directed = true;
            out.print("directed\" ");
        }
        this.saveUserData(this.mFileHandler.getGraphAttributes(), out);
        out.println(" >");
        this.saveVerticesSection(out, g);
        this.saveEdgesSection(out, g);
        out.println("</graph>");
        out.println("</graphml>");
    }

    private void saveVerticesSection(PrintStream out, Graph<V, E> g) {
        int numVertices = g.getVertexCount();
        ArrayList id = new ArrayList(g.getVertices());
        for (int i = 0; i < numVertices; ++i) {
            Object v = id.get(i);
            int vId = i + 1;
            out.print("<node id=\"" + vId + "\" ");
            this.saveUserData(this.mFileHandler.getVertexAttributes().get(v), out);
            out.println("/>");
        }
    }

    private void saveEdgesSection(PrintStream out, Graph<V, E> g) {
        ArrayList id = new ArrayList(g.getVertices());
        for (Object e : g.getEdges()) {
            Pair<V> p = g.getEndpoints(e);
            V src = p.getFirst();
            V dest = p.getSecond();
            int srcId = id.indexOf(src) + 1;
            out.print("<edge source=\"" + srcId + "\" ");
            int destId = id.indexOf(dest) + 1;
            out.print("target=\"" + destId + "\" ");
            if (this.directed) {
                if (g.getEdgeType(e) == EdgeType.UNDIRECTED) {
                    out.print("directed=\"false\" ");
                }
            } else if (g.getEdgeType(e) == EdgeType.DIRECTED) {
                out.print("directed=\"true\" ");
            }
            this.saveUserData(this.mFileHandler.getEdgeAttributes().get(e), out);
            out.println("/>");
        }
    }

    private void saveUserData(Map<String, String> udc, PrintStream out) {
        for (String key : udc.keySet()) {
            String datum;
            if (this.invalidXMLData(key) || (datum = udc.get(key)) == null || this.invalidXMLData(datum)) continue;
            out.print(key + "=\"" + datum + "\" ");
        }
    }

    private boolean invalidXMLData(String str) {
        if (str.indexOf("&") >= 0) {
            return true;
        }
        if (str.indexOf("<") >= 0) {
            return true;
        }
        if (str.indexOf(">") >= 0) {
            return true;
        }
        if (str.indexOf("'") >= 0) {
            return true;
        }
        return str.indexOf("\"") >= 0;
    }

    public void setGraphMLFileHandler(GraphMLFileHandler<V, E> fileHandler) {
        this.mFileHandler = fileHandler;
    }

    public GraphMLFileHandler<V, E> getMFileHandler() {
        return this.mFileHandler;
    }
}

