/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.scoring;

import edu.uci.ics.jung.algorithms.scoring.AbstractIterativeScorerWithPriors;
import edu.uci.ics.jung.algorithms.scoring.util.UniformDegreeWeight;
import edu.uci.ics.jung.graph.Graph;
import org.apache.commons.collections15.Transformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageRankWithPriors<V, E>
extends AbstractIterativeScorerWithPriors<V, E, Double> {
    protected double disappearing_potential;

    public PageRankWithPriors(Graph<V, E> graph, Transformer<E, ? extends Number> edge_weights, Transformer<V, Double> vertex_priors, double alpha) {
        super(graph, edge_weights, vertex_priors, alpha);
    }

    public PageRankWithPriors(Graph<V, E> graph, Transformer<V, Double> vertex_priors, double alpha) {
        super(graph, vertex_priors, alpha);
        this.edge_weights = new UniformDegreeWeight<V, E>(graph);
    }

    @Override
    public double update(V v) {
        this.collectDisappearingPotential(v);
        double total_input = 0.0;
        for (Object e : this.graph.getInEdges(v)) {
            V w = this.graph.getOpposite(v, e);
            total_input += (Double)this.getCurrentValue(w) * this.getEdgeWeight(w, e).doubleValue();
        }
        double new_value = total_input * (1.0 - this.alpha) + (Double)this.getVertexPrior(v) * this.alpha;
        this.setOutputValue(v, new_value);
        return Math.abs((Double)this.getCurrentValue(v) - new_value);
    }

    @Override
    protected void afterStep() {
        if (this.disappearing_potential > 0.0) {
            for (Object v : this.graph.getVertices()) {
                this.setOutputValue(v, (Double)this.getOutputValue(v) + (1.0 - this.alpha) * (this.disappearing_potential * (Double)this.getVertexPrior(v)));
            }
            this.disappearing_potential = 0.0;
        }
        super.afterStep();
    }

    @Override
    protected void collectDisappearingPotential(V v) {
        if (this.graph.outDegree(v) == 0) {
            if (this.isDisconnectedGraphOK()) {
                this.disappearing_potential += ((Double)this.getCurrentValue(v)).doubleValue();
            } else {
                throw new IllegalArgumentException("Outdegree of " + v + " must be > 0");
            }
        }
    }
}

