/*
 * Decompiled with CFR 0.152.
 */
package edu.tsinghua.keg.graphsummary.evaluate;

import edu.tsinghua.keg.graphsummary.evaluate.GraphSummMarker;
import edu.uci.ics.jung.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.visualization.control.AbstractPopupGraphMousePlugin;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Point2D;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;

class PopupGraphMousePlugin<V, E>
extends AbstractPopupGraphMousePlugin
implements MouseListener {
    private GraphSummMarker<V, E> marker;

    public PopupGraphMousePlugin(GraphSummMarker<V, E> marker) {
        this(0, marker);
    }

    public PopupGraphMousePlugin(int modifiers, GraphSummMarker<V, E> marker) {
        super(modifiers);
        this.marker = marker;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        super.mouseClicked(e);
        if (e.getClickCount() == 2 && e.getButton() == 1) {
            Point p = e.getPoint();
            GraphElementAccessor pickSupport = this.marker.vv.getPickSupport();
            if (pickSupport != null) {
                Object v = pickSupport.getVertex(this.marker.vv.getGraphLayout(), ((Point2D)p).getX(), ((Point2D)p).getY());
                if (v != null) {
                    if (this.marker.vertex_deleted.get(v).booleanValue()) {
                        this.resumeVertexOnly(v);
                        this.marker.vv.repaint();
                    } else {
                        this.removeVertex(v);
                        this.marker.vv.repaint();
                    }
                } else {
                    Object edge = pickSupport.getEdge(this.marker.vv.getGraphLayout(), ((Point2D)p).getX(), ((Point2D)p).getY());
                    if (edge != null) {
                        if (this.marker.edge_deleted.get(edge).booleanValue()) {
                            this.resumeEdge(edge);
                            this.marker.vv.repaint();
                        } else {
                            this.removeEdge(edge);
                            this.marker.vv.repaint();
                        }
                    }
                }
            }
        }
    }

    @Override
    protected void handlePopup(MouseEvent e) {
        Point p = e.getPoint();
        GraphElementAccessor pickSupport = this.marker.vv.getPickSupport();
        if (pickSupport != null) {
            final Object v = pickSupport.getVertex(this.marker.vv.getGraphLayout(), ((Point2D)p).getX(), ((Point2D)p).getY());
            if (v != null) {
                this.marker.vv.getPickedVertexState().clear();
                this.marker.vv.getPickedVertexState().pick(v, true);
                JPopupMenu popup = new JPopupMenu();
                if (this.marker.vertex_deleted.get(v).booleanValue()) {
                    popup.add(new AbstractAction("\u4ec5\u6062\u590d\u8282\u70b9"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PopupGraphMousePlugin.this.resumeVertexOnly(v);
                            ((PopupGraphMousePlugin)PopupGraphMousePlugin.this).marker.vv.repaint();
                        }
                    });
                    popup.add(new AbstractAction("\u6062\u590d\u8282\u70b9\u53ca\u8fb9"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PopupGraphMousePlugin.this.resumeVertexAndEdges(v);
                            ((PopupGraphMousePlugin)PopupGraphMousePlugin.this).marker.vv.repaint();
                        }
                    });
                } else {
                    popup.add(new AbstractAction("\u5220\u9664\u8282\u70b9\u53ca\u5176\u5bf9\u5e94\u7684\u8fb9"){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            PopupGraphMousePlugin.this.removeVertex(v);
                            ((PopupGraphMousePlugin)PopupGraphMousePlugin.this).marker.vv.repaint();
                        }
                    });
                }
                popup.show(this.marker.vv, e.getX(), e.getY());
            } else {
                final Object edge = pickSupport.getEdge(this.marker.vv.getGraphLayout(), ((Point2D)p).getX(), ((Point2D)p).getY());
                if (edge != null) {
                    this.marker.vv.getPickedEdgeState().clear();
                    this.marker.vv.getPickedEdgeState().pick(edge, true);
                    JPopupMenu popup = new JPopupMenu();
                    if (this.marker.edge_deleted.get(edge).booleanValue()) {
                        popup.add(new AbstractAction("\u6062\u590d\u8fb9\u53ca\u4e24\u4e2a\u7aef\u70b9"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                PopupGraphMousePlugin.this.resumeEdge(edge);
                                ((PopupGraphMousePlugin)PopupGraphMousePlugin.this).marker.vv.repaint();
                            }
                        });
                    } else {
                        popup.add(new AbstractAction("\u5220\u9664\u8fb9"){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                PopupGraphMousePlugin.this.removeEdge(edge);
                                ((PopupGraphMousePlugin)PopupGraphMousePlugin.this).marker.vv.repaint();
                            }
                        });
                    }
                    popup.show(this.marker.vv, e.getX(), e.getY());
                }
            }
        }
    }

    public void removeEdge(E edge) {
        this.marker.edge_deleted.put(edge, true);
        this.marker.refreshCanSave(true);
    }

    public void resumeEdge(E edge) {
        this.marker.edge_deleted.put(edge, false);
        Pair vs = this.marker.graph.getEndpoints(edge);
        for (Object v : vs) {
            this.marker.vertex_deleted.put((Boolean)v, false);
        }
        this.marker.refreshCanSave(true);
    }

    public void resumeVertexOnly(V v) {
        this.marker.vertex_deleted.put((Boolean)v, false);
        this.marker.refreshCanSave(true);
    }

    public void resumeVertexAndEdges(V v) {
        this.marker.vertex_deleted.put((Boolean)v, false);
        Collection es = this.marker.graph.getInEdges(v);
        for (Object ee : es) {
            Pair nodes = this.marker.graph.getEndpoints(ee);
            for (Object vv : nodes) {
                if (vv.equals(v) || this.marker.vertex_deleted.get(vv).booleanValue()) continue;
                this.marker.edge_deleted.put(ee, false);
            }
        }
        this.marker.refreshCanSave(true);
    }

    public void removeVertex(V v) {
        this.marker.vertex_deleted.put((Boolean)v, true);
        for (Object edge : this.marker.vv.getGraphLayout().getGraph().getInEdges(v)) {
            this.marker.edge_deleted.put(edge, true);
        }
        this.marker.refreshCanSave(true);
    }

    public void removeSelectedVertex() {
        GraphElementAccessor pickSupport = this.marker.vv.getPickSupport();
        for (Object v : this.marker.vertex_deleted.keySet()) {
            if (!this.marker.vv.getPickedVertexState().isPicked(v)) continue;
            this.removeVertex(v);
        }
        this.marker.vv.getPickedVertexState().clear();
    }

    public void removeUnselectedVertex() {
        GraphElementAccessor pickSupport = this.marker.vv.getPickSupport();
        for (Object v : this.marker.vertex_deleted.keySet()) {
            if (this.marker.vv.getPickedVertexState().isPicked(v)) continue;
            this.removeVertex(v);
        }
        this.marker.vv.getPickedVertexState().clear();
    }

    public void resumeSelectedVertex() {
        GraphElementAccessor pickSupport = this.marker.vv.getPickSupport();
        for (Object v : this.marker.vertex_deleted.keySet()) {
            if (!this.marker.vv.getPickedVertexState().isPicked(v)) continue;
            this.marker.vertex_deleted.put((Boolean)v, false);
            Collection es = this.marker.graph.getInEdges(v);
            for (Object ee : es) {
                Pair nodes = this.marker.graph.getEndpoints(ee);
                for (Object vv : nodes) {
                    if (vv.equals(v) || this.marker.vertex_deleted.get(vv).booleanValue() && !this.marker.vv.getPickedVertexState().isPicked(vv)) continue;
                    this.marker.edge_deleted.put(ee, false);
                }
            }
        }
        this.marker.vv.getPickedVertexState().clear();
        this.marker.refreshCanSave(true);
    }

    public void resumeUnselectedVertex() {
        GraphElementAccessor pickSupport = this.marker.vv.getPickSupport();
        for (Object v : this.marker.vertex_deleted.keySet()) {
            if (this.marker.vv.getPickedVertexState().isPicked(v)) continue;
            this.marker.vertex_deleted.put((Boolean)v, false);
            Collection es = this.marker.graph.getInEdges(v);
            for (Object ee : es) {
                Pair nodes = this.marker.graph.getEndpoints(ee);
                for (Object vv : nodes) {
                    if (vv.equals(v) || this.marker.vertex_deleted.get(vv).booleanValue() && this.marker.vv.getPickedVertexState().isPicked(vv)) continue;
                    this.marker.edge_deleted.put(ee, false);
                }
            }
        }
        this.marker.vv.getPickedVertexState().clear();
        this.marker.refreshCanSave(true);
    }
}

