/*
 * Decompiled with CFR 0.152.
 */
package edu.tsinghua.keg.graphsummary.evaluate;

import edu.tsinghua.keg.graphsummary.evaluate.AuthorNameTips;
import edu.tsinghua.keg.graphsummary.evaluate.EdgeDisplayPredicate;
import edu.tsinghua.keg.graphsummary.evaluate.EdgeLabeller;
import edu.tsinghua.keg.graphsummary.evaluate.EdgePaintTransf;
import edu.tsinghua.keg.graphsummary.evaluate.EdgeStyleStrokeTransf;
import edu.tsinghua.keg.graphsummary.evaluate.GraphReader;
import edu.tsinghua.keg.graphsummary.evaluate.GraphWriter;
import edu.tsinghua.keg.graphsummary.evaluate.PopupGraphMousePlugin;
import edu.tsinghua.keg.graphsummary.evaluate.VertexDisplayPredicate;
import edu.tsinghua.keg.graphsummary.evaluate.VertexDrawColor;
import edu.tsinghua.keg.graphsummary.evaluate.VertexFillColor;
import edu.tsinghua.keg.graphsummary.evaluate.VertexLabeller;
import edu.tsinghua.keg.graphsummary.evaluate.VertexShapeSizeAspect;
import edu.tsinghua.keg.graphsummary.evaluate.VertexStrokeHighlight;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedSparseGraph;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.EdgeShape;
import edu.uci.ics.jung.visualization.layout.LayoutTransition;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.util.Animator;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.functors.ConstantTransformer;

public class GraphSummMarker<V, E>
extends JApplet
implements ActionListener,
ChangeListener,
KeyListener {
    protected JCheckBox filterDeletedCB;
    protected JCheckBox useDiffLineStyleCB;
    protected JCheckBox strokePickVertexCB;
    protected JCheckBox scaleVertexCB;
    protected JCheckBox v_show_labels;
    protected JCheckBox v_show_names;
    protected JSlider filterSmallVertexSlider;
    protected JSlider filterSmallVertexDegreeSlider;
    protected JSlider filterSmallEdgeSlider;
    protected JRadioButton e_line;
    protected JRadioButton e_quad;
    protected JRadioButton e_cubic;
    protected JButton refresh;
    protected JCheckBox e_show_labels;
    protected JLabel v_small;
    protected JLabel v_small_degree;
    protected JLabel e_small;
    protected JButton load;
    protected JButton save;
    protected JButton image;
    protected Transformer<V, String> vs;
    protected Transformer<E, String> es;
    protected Transformer<E, String> es_none;
    public HashMap<V, Integer> vertex_labels = new HashMap();
    public HashMap<V, String> vertex_names = new HashMap();
    public HashMap<E, Integer> edge_weights = new HashMap();
    public HashMap<V, Boolean> vertex_deleted = new HashMap();
    public HashMap<E, Boolean> edge_deleted = new HashMap();
    public Graph<V, E> graph = null;
    public boolean strokePickVertex = true;
    public boolean useDiffLineStyle = true;
    public boolean scaleVertex = true;
    public boolean filterDeleted = false;
    public boolean showPublicationCount = true;
    public boolean showAuthorName = false;
    public int filterSmallVertex = 1;
    public int filterSmallEdge = 1;
    public int filterSmallVertexDegree = 1;
    private String filename = null;
    private String loadDir = ".";
    private String saveDir = ".";
    private String imageDir = ".";
    public boolean canSave = false;
    protected VisualizationViewer<V, E> vv;
    protected DefaultModalGraphMouse<V, E> gm;
    protected PopupGraphMousePlugin<V, E> popupGraphMousePlugin;
    private GraphSummMarker<V, E> thisApp = this;

    private GraphSummMarker() {
    }

    @Override
    public void start() {
        this.getContentPane().add(this.startFunction());
    }

    public static void main(String[] s) {
        JFrame jf = new JFrame("Graph Summarization Benchmark Marker");
        jf.setDefaultCloseOperation(3);
        JPanel jp = new GraphSummMarker().startFunction();
        jf.getContentPane().add(jp);
        jf.pack();
        jf.setVisible(true);
        jf.setExtendedState(6);
    }

    public JPanel startFunction() {
        this.graph = new UndirectedSparseGraph();
        FRLayout<V, E> layout = new FRLayout<V, E>(this.graph);
        layout.setSize(new Dimension(900, 900));
        this.vv = new VisualizationViewer<V, E>(layout);
        this.es_none = new ConstantTransformer<Object>(null);
        this.vs = new VertexLabeller<V, E>(this.thisApp);
        this.es = new EdgeLabeller<V, E>(this.thisApp);
        VertexFillColor<V, E> vFillColor = new VertexFillColor<V, E>(this.thisApp);
        this.vv.getRenderContext().setVertexFillPaintTransformer(vFillColor);
        VertexDrawColor<V, E> vDrawColor = new VertexDrawColor<V, E>(this.thisApp);
        this.vv.getRenderContext().setVertexDrawPaintTransformer(vDrawColor);
        VertexStrokeHighlight<V, E> vsh = new VertexStrokeHighlight<V, E>(this.thisApp);
        this.vv.getRenderContext().setVertexStrokeTransformer(vsh);
        this.vv.getRenderContext().setVertexLabelTransformer(this.vs);
        this.vv.getRenderContext().setEdgeLabelTransformer(this.es);
        VertexShapeSizeAspect<V, E> vssa = new VertexShapeSizeAspect<V, E>(this.thisApp);
        this.vv.getRenderContext().setVertexShapeTransformer(vssa);
        VertexDisplayPredicate<V, E> vdp = new VertexDisplayPredicate<V, E>(this.thisApp);
        this.vv.getRenderContext().setVertexIncludePredicate(vdp);
        EdgeStyleStrokeTransf<V, E> esst = new EdgeStyleStrokeTransf<V, E>(this.thisApp);
        this.vv.getRenderContext().setEdgeStrokeTransformer(esst);
        EdgeDisplayPredicate<V, E> edp = new EdgeDisplayPredicate<V, E>(this.thisApp);
        this.vv.getRenderContext().setEdgeIncludePredicate(edp);
        this.vv.getRenderContext().setEdgeShapeTransformer(new EdgeShape.Line());
        EdgePaintTransf<V, E> ept = new EdgePaintTransf<V, E>(this.thisApp);
        this.vv.getRenderContext().setEdgeDrawPaintTransformer(ept);
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        this.vv.setBackground(Color.white);
        GraphZoomScrollPane scrollPane = new GraphZoomScrollPane(this.vv);
        jp.add(scrollPane);
        this.gm = new DefaultModalGraphMouse();
        this.vv.setGraphMouse(this.gm);
        this.popupGraphMousePlugin = new PopupGraphMousePlugin<V, E>(this.thisApp);
        this.gm.add(this.popupGraphMousePlugin);
        this.gm.setMode(ModalGraphMouse.Mode.PICKING);
        this.addBottomControls(jp);
        this.vv.setVertexToolTipTransformer(new AuthorNameTips<V, E>(this.thisApp));
        this.vv.addKeyListener(this);
        return jp;
    }

    public Graph<V, E> loadGraph(String filename) throws IOException {
        FileReader reader = new FileReader(filename);
        GraphReader gr = new GraphReader();
        Graph g = gr.load(reader);
        this.graph = g;
        this.edge_deleted = gr.edge_deleted;
        this.edge_weights = gr.edge_weights;
        this.vertex_deleted = gr.vertex_deleted;
        this.vertex_labels = gr.vertex_labels;
        this.vertex_names = gr.vertex_names;
        reader.close();
        return g;
    }

    public void save(File file) throws IOException {
        FileWriter fw = new FileWriter(file);
        GraphWriter gw = new GraphWriter();
        gw.save(this.graph, this.vertex_labels, this.vertex_names, this.edge_weights, fw, this.vertex_deleted, this.edge_deleted);
        fw.close();
        this.canSave = false;
    }

    protected void addBottomControls(JPanel jp) {
        JPanel right_area = new JPanel();
        right_area.setPreferredSize(new Dimension(190, 0));
        right_area.setMaximumSize(new Dimension(190, 0));
        right_area.setLayout(new BorderLayout());
        jp.add((Component)right_area, "East");
        JPanel file_buttons = new JPanel();
        file_buttons.setLayout(new FlowLayout());
        right_area.add((Component)file_buttons, "North");
        this.load = new JButton("Load...");
        this.load.setEnabled(!this.canSave);
        this.load.addActionListener(this);
        this.save = new JButton("Save...");
        this.save.setEnabled(this.canSave);
        this.save.addActionListener(this);
        file_buttons.add(this.load);
        file_buttons.add(this.save);
        Box control_panel = Box.createVerticalBox();
        right_area.add((Component)control_panel, "Center");
        Box vertex_panel = Box.createVerticalBox();
        vertex_panel.setBorder(BorderFactory.createTitledBorder("\u8282\u70b9\u5c5e\u6027"));
        vertex_panel.setAlignmentX(0.0f);
        Box edge_panel = Box.createVerticalBox();
        edge_panel.setAlignmentX(0.0f);
        edge_panel.setBorder(BorderFactory.createTitledBorder("\u8fde\u7ebf\u5c5e\u6027"));
        Box both_panel = Box.createVerticalBox();
        both_panel.setAlignmentX(0.0f);
        control_panel.add(vertex_panel);
        control_panel.add(edge_panel);
        control_panel.add(both_panel);
        this.strokePickVertexCB = new JCheckBox("\u9009\u4e2d\u65f6\u63cf\u8fb9");
        this.strokePickVertexCB.setSelected(true);
        this.strokePickVertexCB.addActionListener(this);
        this.v_show_labels = new JCheckBox("\u663e\u793a\u4f5c\u8005\u53d1\u8868\u6587\u7ae0\u6570");
        this.v_show_labels.setSelected(true);
        this.v_show_labels.addActionListener(this);
        this.v_show_names = new JCheckBox("\u663e\u793a\u4f5c\u8005\u540d\u5b57");
        this.v_show_names.setSelected(false);
        this.v_show_names.addActionListener(this);
        this.scaleVertexCB = new JCheckBox("\u6309\u53d1\u8868\u6587\u7ae0\u6570\u6539\u53d8\u5927\u5c0f");
        this.scaleVertexCB.addActionListener(this);
        this.scaleVertexCB.setSelected(true);
        this.filterDeletedCB = new JCheckBox("\u9690\u85cf\u5df2\u5220\u9664\u7684\u8282\u70b9\u548c\u8fb9");
        this.filterDeletedCB.addActionListener(this);
        this.filterSmallVertexSlider = new JSlider(1, 16, 1);
        this.filterSmallVertexSlider.setPaintTicks(true);
        this.filterSmallVertexSlider.setMajorTickSpacing(3);
        this.filterSmallVertexSlider.setMinorTickSpacing(1);
        this.filterSmallVertexSlider.setPaintLabels(true);
        this.filterSmallVertexSlider.setSnapToTicks(true);
        this.filterSmallVertexSlider.addChangeListener(this);
        this.v_small = new JLabel("\u53d1\u8868\u6587\u7ae0\u5c11\u4e8e" + this.filterSmallVertex + "\u7684\u4e0d\u663e\u793a");
        this.filterSmallVertexDegreeSlider = new JSlider(1, 21, 1);
        this.filterSmallVertexDegreeSlider.setPaintTicks(true);
        this.filterSmallVertexDegreeSlider.setMajorTickSpacing(4);
        this.filterSmallVertexDegreeSlider.setMinorTickSpacing(1);
        this.filterSmallVertexDegreeSlider.setPaintLabels(true);
        this.filterSmallVertexDegreeSlider.setSnapToTicks(true);
        this.filterSmallVertexDegreeSlider.addChangeListener(this);
        this.v_small_degree = new JLabel("\u90bb\u8fb9\u5c11\u4e8e" + this.filterSmallVertexDegree + "\u7684\u4e0d\u663e\u793a");
        vertex_panel.add(this.strokePickVertexCB);
        vertex_panel.add(this.v_show_labels);
        vertex_panel.add(this.v_show_names);
        vertex_panel.add(this.scaleVertexCB);
        vertex_panel.add(this.filterDeletedCB);
        vertex_panel.add(this.v_small);
        vertex_panel.add(this.filterSmallVertexSlider);
        vertex_panel.add(this.v_small_degree);
        vertex_panel.add(this.filterSmallVertexDegreeSlider);
        this.useDiffLineStyleCB = new JCheckBox("\u6839\u636e\u5f3a\u5ea6\u8c03\u6574\u7ebf\u6761\u7c97\u7ec6");
        this.useDiffLineStyleCB.setSelected(true);
        this.useDiffLineStyleCB.addActionListener(this);
        this.e_show_labels = new JCheckBox("\u663e\u793a\u5173\u7cfb\u5f3a\u5ea6");
        this.e_show_labels.setSelected(true);
        this.e_show_labels.addActionListener(this);
        this.useDiffLineStyleCB.setAlignmentX(0.0f);
        edge_panel.add(this.useDiffLineStyleCB);
        this.e_show_labels.setAlignmentX(0.0f);
        edge_panel.add(this.e_show_labels);
        this.e_small = new JLabel("\u5173\u7cfb\u5f3a\u5ea6\u5c0f\u4e8e" + this.filterSmallEdge + "\u7684\u4e0d\u663e\u793a");
        edge_panel.add(this.e_small);
        this.filterSmallEdgeSlider = new JSlider(1, 11, 1);
        this.filterSmallEdgeSlider.setPaintTicks(true);
        this.filterSmallEdgeSlider.setMajorTickSpacing(2);
        this.filterSmallEdgeSlider.setMinorTickSpacing(1);
        this.filterSmallEdgeSlider.setPaintLabels(true);
        this.filterSmallEdgeSlider.setSnapToTicks(true);
        this.filterSmallEdgeSlider.addChangeListener(this);
        edge_panel.add(this.filterSmallEdgeSlider);
        Box shape_panel = Box.createVerticalBox();
        shape_panel.setBorder(BorderFactory.createTitledBorder("\u8fb9\u7684\u6837\u5f0f"));
        this.e_line = new JRadioButton(" \u76f4\u7ebf");
        this.e_line.addActionListener(this);
        this.e_line.setSelected(true);
        this.e_quad = new JRadioButton(" \u5f27\u7ebf");
        this.e_quad.addActionListener(this);
        this.e_cubic = new JRadioButton(" \u6b63\u5f26\u7ebf");
        this.e_cubic.addActionListener(this);
        ButtonGroup bg_shape = new ButtonGroup();
        bg_shape.add(this.e_line);
        bg_shape.add(this.e_quad);
        bg_shape.add(this.e_cubic);
        shape_panel.add(this.e_line);
        shape_panel.add(this.e_quad);
        shape_panel.add(this.e_cubic);
        shape_panel.setAlignmentX(0.0f);
        edge_panel.add(shape_panel);
        final CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                scaler.scale(GraphSummMarker.this.vv, 1.1f, GraphSummMarker.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                scaler.scale(GraphSummMarker.this.vv, 0.9090909f, GraphSummMarker.this.vv.getCenter());
            }
        });
        JPanel zoomPanel = new JPanel();
        zoomPanel.setPreferredSize(new Dimension(200, 60));
        zoomPanel.setMaximumSize(new Dimension(200, 60));
        zoomPanel.setBorder(BorderFactory.createTitledBorder("\u663e\u793a"));
        plus.setAlignmentX(0.5f);
        zoomPanel.add(plus);
        minus.setAlignmentX(0.5f);
        zoomPanel.add(minus);
        this.refresh = new JButton("\u91cd\u6392");
        this.refresh.setAlignmentX(0.5f);
        this.refresh.addActionListener(this);
        zoomPanel.add(this.refresh);
        both_panel.add(zoomPanel);
        JPanel fontPanel = new JPanel();
        JComboBox modeBox = this.gm.getModeComboBox();
        modeBox.setAlignmentX(0.5f);
        JPanel modePanel = new JPanel(new BorderLayout()){

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        modePanel.setBorder(BorderFactory.createTitledBorder("\u9f20\u6807\u6a21\u5f0f"));
        modePanel.add(modeBox);
        JPanel comboGrid = new JPanel(new GridLayout(0, 1));
        comboGrid.add(modePanel);
        fontPanel.add(comboGrid);
        this.image = new JButton("Save Image");
        this.image.addActionListener(this);
        fontPanel.add(this.image);
        both_panel.add(fontPanel);
        this.vv.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.CNTR);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        AbstractButton source = (AbstractButton)e.getSource();
        if (source == this.load) {
            int res;
            if (this.canSave && (res = JOptionPane.showConfirmDialog(this.vv.getParent(), "\u5f53\u524d\u56fe\u5df2\u88ab\u4fee\u6539,\u786e\u5b9a\u653e\u5f03\u8fd9\u4e9b\u4fee\u6539\u91cd\u65b0\u8bfb\u5165\u65b0\u56fe\u5417?", "\u786e\u5b9a?", 2)) != 0) {
                return;
            }
            JFileChooser chooser = new JFileChooser();
            FileNameExtensionFilter filter = new FileNameExtensionFilter(".NET Graph File", "net");
            chooser.setFileFilter(filter);
            chooser.setFileSelectionMode(0);
            chooser.setMultiSelectionEnabled(false);
            chooser.setCurrentDirectory(new File(this.loadDir));
            int returnVal = chooser.showOpenDialog(this.vv.getParent());
            if (returnVal == 0) {
                try {
                    this.loadGraph(chooser.getSelectedFile().getAbsolutePath());
                    this.vv.getGraphLayout().setGraph(this.graph);
                    LayoutTransition<V, E> lt = new LayoutTransition<V, E>(this.vv, this.vv.getGraphLayout(), this.vv.getGraphLayout());
                    Animator animator = new Animator(lt);
                    animator.start();
                    this.vv.getRenderContext().getMultiLayerTransformer().setToIdentity();
                    this.vv.repaint();
                    this.refreshCanSave(false);
                    this.filename = chooser.getSelectedFile().getName();
                    this.loadDir = chooser.getSelectedFile().getCanonicalPath();
                }
                catch (Exception e1) {
                    JOptionPane.showMessageDialog(this.vv.getParent(), e1.getMessage(), "\u8bfb\u53d6\u9519\u8bef:", 2);
                }
            }
        } else if (source == this.save) {
            int returnVal;
            JFileChooser chooser = new JFileChooser();
            FileNameExtensionFilter filter = new FileNameExtensionFilter(".NET Graph File", "net");
            chooser.setFileFilter(filter);
            chooser.setFileSelectionMode(0);
            chooser.setMultiSelectionEnabled(false);
            chooser.setCurrentDirectory(new File(this.saveDir));
            if (this.filename != null) {
                String[] files = this.filename.split("\\.");
                String file = String.valueOf(files[0]) + "_sum.net";
                chooser.setSelectedFile(new File(file));
            }
            if ((returnVal = chooser.showSaveDialog(this.vv.getParent())) == 0) {
                try {
                    if (chooser.getSelectedFile().exists()) {
                        int res = JOptionPane.showConfirmDialog(this.vv.getParent(), "\u6587\u4ef6" + chooser.getSelectedFile() + "\u5df2\u7ecf\u5b58\u5728,\u786e\u5b9a\u8981\u8986\u76d6\u539f\u6765\u7684\u6587\u4ef6\u5417?", "\u786e\u5b9a?", 2);
                        if (res == 0) {
                            this.save(chooser.getSelectedFile());
                            this.refreshCanSave(false);
                        }
                    } else {
                        this.save(chooser.getSelectedFile());
                    }
                    this.saveDir = chooser.getSelectedFile().getCanonicalPath();
                }
                catch (Exception e1) {
                    JOptionPane.showMessageDialog(this.vv.getParent(), e1.getMessage(), "\u5b58\u76d8\u9519\u8bef:", 2);
                }
            }
        } else if (source == this.image) {
            int returnVal;
            JFileChooser chooser = new JFileChooser();
            FileNameExtensionFilter filter = new FileNameExtensionFilter(".PNG PNG Image File", "png");
            chooser.setFileFilter(filter);
            chooser.setFileSelectionMode(0);
            chooser.setMultiSelectionEnabled(false);
            chooser.setCurrentDirectory(new File(this.imageDir));
            if (this.filename != null) {
                String[] files = this.filename.split("\\.");
                String file = this.canSave ? String.valueOf(files[0]) + "_sum.png" : String.valueOf(files[0]) + ".png";
                chooser.setSelectedFile(new File(file));
            }
            if ((returnVal = chooser.showSaveDialog(this.vv.getParent())) == 0) {
                try {
                    if (chooser.getSelectedFile().exists()) {
                        int res = JOptionPane.showConfirmDialog(this.vv.getParent(), "\u6587\u4ef6" + chooser.getSelectedFile() + "\u5df2\u7ecf\u5b58\u5728,\u786e\u5b9a\u8981\u8986\u76d6\u539f\u6765\u7684\u6587\u4ef6\u5417?", "\u786e\u5b9a?", 2);
                        if (res == 0) {
                            this.printImage(chooser.getSelectedFile());
                        }
                    } else {
                        this.printImage(chooser.getSelectedFile());
                    }
                    this.imageDir = chooser.getSelectedFile().getCanonicalPath();
                }
                catch (Exception e1) {
                    JOptionPane.showMessageDialog(this.vv.getParent(), e1.getMessage(), "\u5b58\u76d8\u9519\u8bef:", 2);
                }
            }
        } else if (source == this.filterDeletedCB) {
            this.filterDeleted = source.isSelected();
        } else if (source == this.useDiffLineStyleCB) {
            this.useDiffLineStyle = source.isSelected();
        } else if (source == this.strokePickVertexCB) {
            this.strokePickVertex = source.isSelected();
        } else if (source == this.v_show_labels) {
            this.showPublicationCount = source.isSelected();
        } else if (source == this.v_show_names) {
            this.showAuthorName = source.isSelected();
        } else if (source == this.e_show_labels) {
            if (source.isSelected()) {
                this.vv.getRenderContext().setEdgeLabelTransformer(this.es);
            } else {
                this.vv.getRenderContext().setEdgeLabelTransformer(this.es_none);
            }
        } else if (source == this.scaleVertexCB) {
            this.scaleVertex = source.isSelected();
        } else if (source == this.e_line) {
            if (source.isSelected()) {
                this.vv.getRenderContext().setEdgeShapeTransformer(new EdgeShape.Line());
            }
        } else if (source == this.e_quad) {
            if (source.isSelected()) {
                this.vv.getRenderContext().setEdgeShapeTransformer(new EdgeShape.QuadCurve());
            }
        } else if (source == this.e_cubic) {
            if (source.isSelected()) {
                this.vv.getRenderContext().setEdgeShapeTransformer(new EdgeShape.CubicCurve());
            }
        } else if (source == this.refresh) {
            LayoutTransition<V, E> lt = new LayoutTransition<V, E>(this.vv, this.vv.getGraphLayout(), this.vv.getGraphLayout());
            Animator animator = new Animator(lt);
            animator.start();
            this.vv.getRenderContext().getMultiLayerTransformer().setToIdentity();
            this.vv.repaint();
        }
        this.vv.repaint();
    }

    public void refreshCanSave(boolean b) {
        this.canSave = b;
        this.save.setEnabled(this.canSave);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        JSlider s1 = (JSlider)e.getSource();
        if (s1 == this.filterSmallVertexSlider) {
            this.filterSmallVertex = s1.getValue();
            this.v_small.setText("\u53d1\u8868\u6587\u7ae0\u5c11\u4e8e" + this.filterSmallVertex + "\u7684\u4e0d\u663e\u793a");
            this.vv.repaint();
        } else if (s1 == this.filterSmallEdgeSlider) {
            this.filterSmallEdge = s1.getValue();
            this.e_small.setText("\u5173\u7cfb\u5f3a\u5ea6\u5c0f\u4e8e" + this.filterSmallEdge + "\u7684\u4e0d\u663e\u793a");
            this.vv.repaint();
        } else if (s1 == this.filterSmallVertexDegreeSlider) {
            this.filterSmallVertexDegree = s1.getValue();
            this.v_small_degree.setText("\u90bb\u8fb9\u5c11\u4e8e" + this.filterSmallVertexDegree + "\u7684\u4e0d\u663e\u793a");
            this.vv.repaint();
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.isShiftDown()) {
            if (e.getKeyCode() == 88) {
                this.popupGraphMousePlugin.removeSelectedVertex();
                this.vv.repaint();
            } else if (e.getKeyCode() == 82) {
                this.popupGraphMousePlugin.resumeSelectedVertex();
                this.vv.repaint();
            }
        } else if (e.isAltDown()) {
            if (e.getKeyCode() == 88) {
                this.popupGraphMousePlugin.removeUnselectedVertex();
                this.vv.repaint();
            } else if (e.getKeyCode() == 82) {
                this.popupGraphMousePlugin.resumeUnselectedVertex();
                this.vv.repaint();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private void printImage(File file) throws IOException {
        BufferedImage image = new BufferedImage(this.vv.getWidth(), this.vv.getHeight(), 1);
        Graphics2D g2 = image.createGraphics();
        this.vv.paint(g2);
        g2.dispose();
        ImageIO.write((RenderedImage)image, "png", file);
    }
}

