/*
 * Decompiled with CFR 0.152.
 */
package edu.tsinghua.keg.graphsummary.evaluate;

import edu.tsinghua.keg.graphsummary.evaluate.GraphSummMarker;
import edu.uci.ics.jung.graph.util.Pair;
import java.awt.Color;
import java.awt.Paint;
import org.apache.commons.collections15.Transformer;

public class EdgePaintTransf<V, E>
implements Transformer<E, Paint> {
    private GraphSummMarker<V, E> marker;
    private static final Paint basicLine = new Color(0.0f, 0.0f, 0.0f, 1.0f);
    private static final Paint basicDeletedLine = new Color(0.0f, 0.0f, 0.0f, 0.4f);
    private static final Paint pickedLine = new Color(0.0f, 0.0f, 1.0f, 1.0f);
    private static final Paint pickedDeletedLine = new Color(0.0f, 0.0f, 1.0f, 0.8f);

    public EdgePaintTransf(GraphSummMarker<V, E> marker) {
        this.marker = marker;
    }

    @Override
    public Paint transform(E e) {
        if (this.marker.vv.getPickedEdgeState().isPicked(e)) {
            if (this.marker.edge_deleted.get(e).booleanValue()) {
                return pickedDeletedLine;
            }
            return pickedLine;
        }
        Pair p = this.marker.graph.getEndpoints(e);
        for (Object v : p) {
            if (!this.marker.vv.getPickedVertexState().isPicked(v)) continue;
            if (this.marker.edge_deleted.get(e).booleanValue()) {
                return pickedDeletedLine;
            }
            return pickedLine;
        }
        if (this.marker.edge_deleted.get(e).booleanValue()) {
            return basicDeletedLine;
        }
        return basicLine;
    }
}

